/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.validation.api;

import com.github.jmodel.validation.api.ValidationEngine;
import com.github.jmodel.validation.spi.ValidationEngineFactory;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class ValidationEngineFactoryService {
    private static ValidationEngineFactoryService service;
    private ServiceLoader<ValidationEngineFactory> loader = ServiceLoader.load(ValidationEngineFactory.class);

    private ValidationEngineFactoryService() {
    }

    public static synchronized ValidationEngineFactoryService getInstance() {
        if (service == null) {
            service = new ValidationEngineFactoryService();
        }
        return service;
    }

    public ValidationEngine getEngine() {
        ValidationEngine engine = null;
        try {
            Iterator<ValidationEngineFactory> engineFactorys = this.loader.iterator();
            while (engine == null && engineFactorys.hasNext()) {
                ValidationEngineFactory engineFactory = engineFactorys.next();
                engine = engineFactory.getEngine();
            }
        }
        catch (ServiceConfigurationError serviceError) {
            engine = null;
            serviceError.printStackTrace();
        }
        return engine;
    }
}

