/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.validation.api.ext;

import com.github.jmodel.validation.api.ext.ExtValidator;
import com.github.jmodel.validation.spi.ext.ExtValidatorProvider;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class ExtValidatorProviderService {
    private static ExtValidatorProviderService service;
    private ServiceLoader<ExtValidatorProvider> loader = ServiceLoader.load(ExtValidatorProvider.class);

    private ExtValidatorProviderService() {
    }

    public static synchronized ExtValidatorProviderService getInstance() {
        if (service == null) {
            service = new ExtValidatorProviderService();
        }
        return service;
    }

    public ExtValidator getValidator(String validatorName) {
        ExtValidator validator = null;
        try {
            Iterator<ExtValidatorProvider> validatorProviders = this.loader.iterator();
            while (validator == null && validatorProviders.hasNext()) {
                ExtValidatorProvider validatorProvider = validatorProviders.next();
                validator = validatorProvider.getValidator(validatorName);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            validator = null;
            serviceError.printStackTrace();
        }
        return validator;
    }
}

