/*
 * Decompiled with CFR 0.152.
 */
package com.github.joineral32.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.Nonnull;

public final class FactorUtil {
    private FactorUtil() {
    }

    public static Set<Long> findFactorsOf(@Nonnull Long number) {
        Preconditions.checkNotNull((Object)number, (Object)"findFactorsOf is null-hostile and number is null.");
        return FactorUtil.findFactorsOf((long)number);
    }

    public static Set<Long> findFactorsOf(long number) {
        boolean parity = number % 2L == 0L;
        Set factors = LongStream.rangeClosed(1L, LongMath.sqrt((long)number, (RoundingMode)RoundingMode.UP)).parallel().filter(l -> parity || l % 2L != 0L).filter(l2 -> number % l2 == 0L).mapToObj(l -> l).collect(Collectors.toSet());
        Set complementaryFactors = factors.parallelStream().map(l2 -> number / l2).collect(Collectors.toSet());
        return ImmutableSet.copyOf((Collection)Sets.union(factors, complementaryFactors));
    }
}

