/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.select;

import com.github.jonathanhds.sqlbuilder.Context;
import com.github.jonathanhds.sqlbuilder.TerminalExpression;
import com.github.jonathanhds.sqlbuilder.select.OrderBy;
import com.github.jonathanhds.sqlbuilder.select.OrderByType;
import com.github.jonathanhds.sqlbuilder.select.RowMapper;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Having
implements TerminalExpression {
    private final Context context;
    private boolean terminated = false;
    private final List<String> conditions;

    Having(Context context) {
        this.context = context;
        this.context.appendLine("HAVING");
        this.conditions = new LinkedList<String>();
    }

    Having(Context context, String ... conditions) {
        this(context);
        this.conditions.addAll(Arrays.asList(conditions));
    }

    public Having condition(String condition) {
        this.conditions.add(condition);
        return this;
    }

    public Having conditions(String ... conditions) {
        this.conditions.addAll(Arrays.asList(conditions));
        return this;
    }

    public OrderBy orderBy(String ... columns) {
        this.terminate();
        return new OrderBy(this.context, columns);
    }

    public OrderBy orderBy(OrderByType order, String ... columns) {
        this.terminate();
        return new OrderBy(this.context, order, columns);
    }

    public OrderBy orderBy(String column, OrderByType order) {
        this.terminate();
        return new OrderBy(this.context, order, column);
    }

    @Override
    public <E> List<E> list(RowMapper<E> rowMapper) throws SQLException {
        this.terminate();
        return this.context.list(rowMapper);
    }

    @Override
    public <E> E single(RowMapper<E> rowMapper) throws SQLException {
        this.terminate();
        return this.context.single(rowMapper);
    }

    public String toString() {
        this.terminate();
        return this.context.toString();
    }

    private void terminate() {
        if (!this.terminated) {
            this.context.appendLine(StringUtils.join(this.conditions, (String)", "));
            this.terminated = true;
        }
    }
}

