/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.select;

import com.github.jonathanhds.sqlbuilder.Context;
import com.github.jonathanhds.sqlbuilder.select.From;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Select {
    private Context context;
    private final List<String> columns;

    public Select(Context context) {
        this.context = context;
        this.context.appendLine("SELECT");
        this.columns = new LinkedList<String>();
    }

    public From from() {
        this.context.appendLine(StringUtils.join(this.columns, (String)",\n"));
        return new From(this.context);
    }

    public Select all() {
        this.append("*");
        return this;
    }

    public Select column(String column) {
        this.append(column);
        return this;
    }

    public Select columns(String ... columns) {
        for (String column : columns) {
            this.append(column);
        }
        return this;
    }

    public Select count(String column) {
        this.append("COUNT(" + column + ")");
        return this;
    }

    private void append(String expression) {
        this.columns.add(expression);
    }

    public String toString() {
        return this.context.toString();
    }
}

