/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.update;

import com.github.jonathanhds.sqlbuilder.Context;
import com.github.jonathanhds.sqlbuilder.IllegalQueryException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class Update {
    private Context context;
    private boolean terminated = false;
    private String table;
    private Map<String, String> assignments;
    private Collection<String> conditions;

    public Update(Context context) {
        this.context = context;
        this.context.append("UPDATE ");
        this.assignments = new LinkedHashMap<String, String>();
        this.conditions = new LinkedList<String>();
    }

    public Update(Context context, String table) {
        this(context);
        this.table = table;
    }

    public Update table(String table) {
        this.table = table;
        return this;
    }

    public Update set(String column, String value) {
        this.assignments.put(column, value);
        return this;
    }

    public Update where(String condition) {
        this.conditions.add(condition);
        return this;
    }

    public Update and(String condition) {
        this.conditions.add(condition);
        return this;
    }

    private void terminate() {
        if (this.assignments.isEmpty()) {
            throw new IllegalQueryException("Not contains SET statements!");
        }
        if (!this.terminated) {
            this.context.append(this.table).appendLine(" SET");
            Iterator<Map.Entry<String, String>> iter = this.assignments.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> assignment = iter.next();
                this.context.append(assignment.getKey()).append(" = ").append("'").append(assignment.getValue()).append("'");
                if (!iter.hasNext()) continue;
                this.context.append(",").newLine();
            }
            if (!this.conditions.isEmpty()) {
                this.context.newLine().append("WHERE ");
                Iterator<String> conditionIter = this.conditions.iterator();
                while (conditionIter.hasNext()) {
                    String condition = conditionIter.next();
                    this.context.append(condition);
                    if (!conditionIter.hasNext()) continue;
                    this.context.newLine().append("AND ");
                }
            }
            this.terminated = true;
        }
    }

    public String toString() {
        this.terminate();
        return this.context.toString();
    }
}

