/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.misc;

import com.github.jonatino.misc.Cacheable;
import com.sun.jna.Native;
import com.sun.jna.Pointer;

public final class MemoryBuffer
extends Pointer {
    private int size;

    public MemoryBuffer(int size) {
        super(Native.malloc((long)size));
        this.size = size;
    }

    public MemoryBuffer putBoolean(boolean value) {
        this.setByte(0L, (byte)(value ? 1 : 0));
        return this;
    }

    public MemoryBuffer putByte(int value) {
        this.setByte(0L, (byte)value);
        return this;
    }

    public MemoryBuffer putShort(int value) {
        this.setShort(0L, (short)value);
        return this;
    }

    public MemoryBuffer putInt(int value) {
        this.setInt(0L, value);
        return this;
    }

    public MemoryBuffer putLong(long value) {
        this.setLong(0L, value);
        return this;
    }

    public MemoryBuffer putFloat(float value) {
        this.setFloat(0L, value);
        return this;
    }

    public MemoryBuffer putDouble(double value) {
        this.setDouble(0L, value);
        return this;
    }

    public void get(byte[] dest) {
        this.read(0L, dest, 0, dest.length);
    }

    public boolean getBoolean() {
        return this.getByte() == 1;
    }

    public int getByte() {
        return this.getByte(0L);
    }

    public int getShort() {
        return this.getShort(0L);
    }

    public int getInt() {
        return this.getInt(0L);
    }

    public long getLong() {
        return this.getLong(0L);
    }

    public float getFloat() {
        return this.getFloat(0L);
    }

    public double getDouble() {
        return this.getDouble(0L);
    }

    public int size() {
        return this.size;
    }

    public byte[] array() {
        byte[] data = Cacheable.array(this.size);
        this.get(data);
        return data;
    }
}

