/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.process;

import com.github.jonatino.misc.Cacheable;
import com.github.jonatino.misc.MemoryBuffer;
import com.github.jonatino.misc.Strings;
import com.github.jonatino.process.Process;
import com.sun.jna.Pointer;

public interface DataSource {
    public MemoryBuffer read(Pointer var1, int var2);

    public Process write(Pointer var1, MemoryBuffer var2);

    public boolean canRead(Pointer var1, int var2);

    default public boolean readBoolean(long address) {
        return this.read(address, 1).getBoolean();
    }

    default public int readByte(long address) {
        return this.read(address, 1).getByte();
    }

    default public int readShort(long address) {
        return this.read(address, 2).getShort();
    }

    default public int readInt(long address) {
        return this.read(address, 4).getInt();
    }

    default public long readUnsignedInt(long address) {
        return Integer.toUnsignedLong(this.read(address, 4).getInt());
    }

    default public long readLong(long address) {
        return this.read(address, 8).getLong();
    }

    default public float readFloat(long address) {
        return this.read(address, 4).getFloat();
    }

    default public double readDouble(long address) {
        return this.read(address, 8).getDouble();
    }

    default public String readString(long address, int length) {
        byte[] bytes = Cacheable.array(length);
        this.read(address, bytes.length).get(bytes);
        return Strings.transform(bytes);
    }

    default public MemoryBuffer read(long address, int size) {
        return this.read(Cacheable.pointer(address), size);
    }

    default public Process writeBoolean(long address, boolean value) {
        return this.write(Cacheable.pointer(address), Cacheable.buffer(1).putBoolean(value));
    }

    default public Process writeByte(long address, int value) {
        return this.write(Cacheable.pointer(address), Cacheable.buffer(1).putByte(value));
    }

    default public Process writeShort(long address, int value) {
        return this.write(Cacheable.pointer(address), Cacheable.buffer(2).putShort(value));
    }

    default public Process writeInt(long address, int value) {
        return this.write(Cacheable.pointer(address), Cacheable.buffer(4).putInt(value));
    }

    default public Process writeLong(long address, long value) {
        return this.write(Cacheable.pointer(address), Cacheable.buffer(8).putLong(value));
    }

    default public Process writeFloat(long address, float value) {
        return this.write(Cacheable.pointer(address), Cacheable.buffer(4).putFloat(value));
    }

    default public Process writeDouble(long address, double value) {
        return this.write(Cacheable.pointer(address), Cacheable.buffer(8).putDouble(value));
    }

    default public boolean canRead(long address, int size) {
        return this.canRead(Cacheable.pointer(address), size);
    }
}

