/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.misc;

import com.github.jonatino.misc.MemoryBuffer;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.function.Function;

public final class Cacheable {
    private static final Int2ObjectArrayMap<MemoryBuffer> bufferCache = new Int2ObjectArrayMap();
    private static final Function<Integer, MemoryBuffer> bufferCreate = MemoryBuffer::new;
    private static final Int2ObjectArrayMap<byte[]> arrayCache = new Int2ObjectArrayMap();
    private static final Function<Integer, byte[]> arrayCreate = byte[]::new;
    private static final Pointer cachedPointer = new Pointer(0L);
    public static final IntByReference INT_BY_REF = new IntByReference();

    public static MemoryBuffer buffer(int size) {
        return (MemoryBuffer)((Object)bufferCache.computeIfAbsent(Integer.valueOf(size), bufferCreate));
    }

    public static byte[] array(int size) {
        return (byte[])arrayCache.computeIfAbsent(Integer.valueOf(size), arrayCreate);
    }

    public static Pointer pointer(long address) {
        Pointer.nativeValue((Pointer)cachedPointer, (long)address);
        return cachedPointer;
    }
}

