/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.process.impl.unix;

import com.github.jonatino.misc.Cacheable;
import com.github.jonatino.misc.MemoryBuffer;
import com.github.jonatino.natives.unix.unix;
import com.github.jonatino.process.AbstractProcess;
import com.github.jonatino.process.Module;
import com.github.jonatino.process.Process;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public final class UnixProcess
extends AbstractProcess {
    private unix.iovec local = new unix.iovec();
    private unix.iovec remote = new unix.iovec();

    public UnixProcess(int id) {
        super(id);
        this.local.setAutoSynch(false);
        this.remote.setAutoSynch(false);
    }

    @Override
    public void initModules() {
        try {
            for (String line : Files.readAllLines(Paths.get("/proc/" + this.id() + "/maps", new String[0]))) {
                String[] split = line.split(" ");
                String[] regionSplit = split[0].split("-");
                long start = Long.parseLong(regionSplit[0], 16);
                long end = Long.parseLong(regionSplit[1], 16);
                long offset = Long.parseLong(split[2], 16);
                if (offset <= 0L) continue;
                String path = "";
                for (int i = 5; i < split.length; ++i) {
                    String s = split[i].trim();
                    if (!s.isEmpty()) {
                        path = path + split[i];
                    }
                    if (s.isEmpty() && ++i > split.length) break;
                    if (!s.isEmpty() || split[i].trim().isEmpty()) continue;
                    path = path + split[i];
                }
                String modulename = path.substring(path.lastIndexOf("/") + 1, path.length());
                this.modules.put(modulename, new Module(this, modulename, Pointer.createConstant((long)start), end - start));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MemoryBuffer read(Pointer address, int size, MemoryBuffer buffer) {
        this.populate(address, buffer);
        if (unix.process_vm_readv(this.id(), this.local, 1L, this.remote, 1L, 0L) != (long)size) {
            throw new RuntimeException("Read memory failed at address " + Pointer.nativeValue((Pointer)address) + " size " + size);
        }
        return buffer;
    }

    @Override
    public Process write(Pointer address, MemoryBuffer buffer) {
        this.populate(address, buffer);
        if (unix.process_vm_writev(this.id(), this.local, 1L, this.remote, 1L, 0L) != (long)buffer.size()) {
            throw new RuntimeException("Write memory failed at address " + Pointer.nativeValue((Pointer)address) + " size " + buffer.size());
        }
        return this;
    }

    @Override
    public boolean canRead(Pointer address, int size) {
        this.populate(address, Cacheable.buffer(size));
        return unix.process_vm_readv(this.id(), this.local, 1L, this.remote, 1L, 0L) == (long)size;
    }

    private void populate(Pointer address, MemoryBuffer buffer) {
        this.local.writeField("iov_base", (Object)buffer);
        this.local.writeField("iov_len", buffer.size());
        this.remote.writeField("iov_base", address);
        this.remote.writeField("iov_len", buffer.size());
    }
}

