/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.process;

import com.github.jonatino.misc.Utils;
import com.github.jonatino.natives.mac.mac;
import com.github.jonatino.natives.unix.libc;
import com.github.jonatino.natives.win32.Kernel32;
import com.github.jonatino.process.Process;
import com.github.jonatino.process.impl.mac.MacProcess;
import com.github.jonatino.process.impl.unix.UnixProcess;
import com.github.jonatino.process.impl.win32.Win32Process;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.ptr.IntByReference;

public final class Processes {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process byName(String name) {
        if (Platform.isWindows()) {
            Tlhelp32.PROCESSENTRY32.ByReference entry = new Tlhelp32.PROCESSENTRY32.ByReference();
            Pointer snapshot = Kernel32.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPALL.intValue(), 0);
            try {
                while (Kernel32.Process32NextW(snapshot, (Tlhelp32.PROCESSENTRY32)entry)) {
                    String processName = Native.toString((char[])entry.szExeFile);
                    if (!name.equals(processName)) continue;
                    Process process = Processes.byId(entry.th32ProcessID.intValue());
                    return process;
                }
            }
            finally {
                Kernel32.CloseHandle(snapshot);
            }
        }
        if (Platform.isMac() || Platform.isLinux()) {
            return Processes.byId(Utils.exec("bash", "-c", "ps -A | grep -m1 \"" + name + "\" | awk '{print $1}'"));
        }
        throw new UnsupportedOperationException("Unknown operating system! (" + System.getProperty("os.name") + ")");
        throw new IllegalStateException("Process '" + name + "' was not found. Are you sure its running?");
    }

    public static Process byId(int id) {
        if ((Platform.isMac() || Platform.isLinux()) && !Processes.isSudo()) {
            throw new RuntimeException("You need to run as root/sudo for unix/osx based environments.");
        }
        if (Platform.isWindows()) {
            return new Win32Process(id, Kernel32.OpenProcess(1080, true, id));
        }
        if (Platform.isLinux()) {
            return new UnixProcess(id);
        }
        if (Platform.isMac()) {
            IntByReference out = new IntByReference();
            if (mac.task_for_pid(mac.mach_task_self(), id, out) != 0) {
                throw new IllegalStateException("Failed to find mach task port for process, ensure you are running as sudo.");
            }
            return new MacProcess(id, out.getValue());
        }
        throw new IllegalStateException("Process " + id + " was not found. Are you sure its running?");
    }

    private static boolean isSudo() {
        return libc.getuid() == 0;
    }
}

