/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.process.impl.mac;

import com.github.jonatino.misc.Cacheable;
import com.github.jonatino.misc.MemoryBuffer;
import com.github.jonatino.natives.mac.mac;
import com.github.jonatino.process.AbstractProcess;
import com.github.jonatino.process.Process;
import com.sun.jna.Pointer;

public final class MacProcess
extends AbstractProcess {
    private final int task;

    public MacProcess(int id, int mach_task) {
        super(id);
        this.task = mach_task;
    }

    public int task() {
        return this.task;
    }

    @Override
    public void initModules() {
    }

    @Override
    public MemoryBuffer read(Pointer address, int size, MemoryBuffer buffer) {
        if (mac.vm_read(this.task(), address, size, buffer, Cacheable.INT_BY_REF) != 0 || Cacheable.INT_BY_REF.getValue() != size) {
            throw new RuntimeException("Read memory failed at address " + Pointer.nativeValue((Pointer)address) + " size " + size);
        }
        Pointer.nativeValue((Pointer)buffer, (long)Pointer.nativeValue((Pointer)buffer.getPointer(0L)));
        return buffer;
    }

    @Override
    public Process write(Pointer address, MemoryBuffer buffer) {
        if (mac.vm_write(this.task(), address, buffer, buffer.size()) != 0) {
            throw new RuntimeException("Write memory failed at address " + Pointer.nativeValue((Pointer)address) + " size " + buffer.size());
        }
        return this;
    }

    @Override
    public boolean canRead(Pointer address, int size) {
        return mac.vm_read(this.task(), address, size, Cacheable.buffer(size), Cacheable.INT_BY_REF) == 0 && Cacheable.INT_BY_REF.getValue() == size;
    }
}

