/*
 * Decompiled with CFR 0.152.
 */
package lzma.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Encoder;
import org.cservenak.streams.Coder;

public class LzmaEncoderWrapper
implements Coder {
    private final Encoder encoder;

    public LzmaEncoderWrapper(Encoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public void code(InputStream in, OutputStream out) throws IOException {
        this.encoder.writeCoderProperties(out);
        long fileSize = -1L;
        for (int i = 0; i < 8; ++i) {
            out.write((int)(fileSize >>> 8 * i) & 0xFF);
        }
        this.encoder.code(in, out, -1L, -1L, null);
    }

    public static class Builder {
        private int dictionnarySize = 0x800000;
        private boolean endMarkerMode = true;
        private int matchFinder = 1;
        private int numFastBytes = 32;

        public Builder useMaximalDictionarySize() {
            this.dictionnarySize = 0x10000000;
            return this;
        }

        public Builder useMediumDictionarySize() {
            this.dictionnarySize = 32768;
            return this;
        }

        public Builder useMinimalDictionarySize() {
            this.dictionnarySize = 1;
            return this;
        }

        public Builder useEndMarkerMode(boolean endMarkerMode) {
            this.endMarkerMode = endMarkerMode;
            return this;
        }

        public Builder useBT4MatchFinder() {
            this.matchFinder = 1;
            return this;
        }

        public Builder useBT2MatchFinder() {
            this.matchFinder = 0;
            return this;
        }

        public Builder useMinimalFastBytes() {
            this.numFastBytes = 5;
            return this;
        }

        public Builder useMediumFastBytes() {
            this.numFastBytes = 32;
            return this;
        }

        public Builder useMaximalFastBytes() {
            this.numFastBytes = 273;
            return this;
        }

        public LzmaEncoderWrapper build() {
            Encoder encoder = new Encoder();
            encoder.setDictionarySize(this.dictionnarySize);
            encoder.setEndMarkerMode(this.endMarkerMode);
            encoder.setMatchFinder(this.matchFinder);
            encoder.setNumFastBytes(this.numFastBytes);
            return new LzmaEncoderWrapper(encoder);
        }
    }
}

