/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class JenaRDFParser
implements RDFParser {
    Iterator<String> _ng = new Iterator<String>(){
        int i = 0;

        @Override
        public void remove() {
            ++this.i;
        }

        @Override
        public String next() {
            return "_:t" + this.i++;
        }

        @Override
        public boolean hasNext() {
            return true;
        }
    };
    Map<String, String> _bns = new LinkedHashMap<String, String>();

    protected String getNameForBlankNode(String node) {
        if (!this._bns.containsKey(node)) {
            this._bns.put(node, this._ng.next());
        }
        return this._bns.get(node);
    }

    public void setPrefix(String fullUri, String prefix) {
    }

    public String getID(Resource r) {
        String rval = null;
        rval = r.isAnon() ? this.getNameForBlankNode(r.getId().toString()) : r.getURI();
        return rval;
    }

    public void importModel(RDFDataset result, Model model) {
        Map nsPrefixMap = model.getNsPrefixMap();
        for (String prefix : nsPrefixMap.keySet()) {
            result.setNamespace(prefix, (String)nsPrefixMap.get(prefix));
        }
        ResIterator subjects = model.listSubjects();
        while (subjects.hasNext()) {
            Resource subject = (Resource)subjects.next();
            this.importResource(result, subject);
        }
    }

    public void importResource(RDFDataset result, Resource subject) {
        String subj = this.getID(subject);
        StmtIterator statements = subject.getModel().listStatements(subject, (Property)null, (RDFNode)null);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            Property predicate = statement.getPredicate();
            RDFNode object = statement.getObject();
            if (object.isLiteral()) {
                Literal literal = object.asLiteral();
                String value = literal.getLexicalForm();
                String datatypeURI = literal.getDatatypeURI();
                String language = literal.getLanguage();
                if ("".equals(language)) {
                    language = null;
                }
                result.addTriple(subj, predicate.getURI(), value, datatypeURI, language);
                continue;
            }
            Resource resource = object.asResource();
            String res = this.getID(resource);
            result.addTriple(subj, predicate.getURI(), res);
        }
    }

    public RDFDataset parse(Object input) throws JSONLDProcessingError {
        RDFDataset result = new RDFDataset();
        if (input == null) {
            return result;
        }
        if (input instanceof Resource) {
            this.importResource(result, (Resource)input);
        } else if (input instanceof Model) {
            this.importModel(result, (Model)input);
        } else {
            throw new JSONLDProcessingError("Jena Serializer expects Model or resource input");
        }
        return result;
    }
}

