/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.jena.JenaRDFParser;
import com.github.jsonldjava.jena.JsonLDReader;
import com.github.jsonldjava.jena.JsonLDWriter;
import com.hp.hpl.jena.rdf.model.impl.IO_Ctl;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.adapters.RDFReaderRIOT;
import org.apache.jena.riot.adapters.RDFWriterRIOT;
import org.apache.jena.riot.system.RiotLib;

public class JenaJSONLD {
    public static Lang JSONLD = LangBuilder.create((String)"JSON-LD", (String)"application/ld+json").addFileExtensions(new String[]{"jsonld"}).build();
    public static RDFFormat JSONLD_FORMAT_FLAT = new RDFFormat(JSONLD, RDFFormat.FLAT);
    public static RDFFormat JSONLD_FORMAT_PRETTY = new RDFFormat(JSONLD, RDFFormat.PRETTY);

    public static void init() {
        IO_Ctl.init();
        JenaJSONLD.registerReader();
        JenaJSONLD.registerWriter();
        JenaJSONLD.registerWithJsonLD();
    }

    protected static void registerWithJsonLD() {
        JsonLdProcessor.registerRDFParser((String)JSONLD.getContentType().getContentType(), (RDFParser)new JenaRDFParser());
    }

    protected static void registerReader() {
        RDFLanguages.register((Lang)JSONLD);
        JsonLDReaderRIOTFactory rfactory = new JsonLDReaderRIOTFactory();
        RDFParserRegistry.registerLangTriples((Lang)JSONLD, (ReaderRIOTFactory)rfactory);
        RDFParserRegistry.registerLangQuads((Lang)JSONLD, (ReaderRIOTFactory)rfactory);
        IO_Jena.registerForModelRead((String)JSONLD.getName(), JsonLDRDFReader.class);
    }

    protected static void registerWriter() {
        RDFWriterRegistry.register((Lang)JSONLD, (RDFFormat)JSONLD_FORMAT_PRETTY);
        JsonLDWriterDatasetRIOTFactory wfactory = new JsonLDWriterDatasetRIOTFactory();
        RDFWriterRegistry.register((RDFFormat)JSONLD_FORMAT_PRETTY, (WriterDatasetRIOTFactory)wfactory);
        RDFWriterRegistry.register((RDFFormat)JSONLD_FORMAT_FLAT, (WriterDatasetRIOTFactory)wfactory);
        JsonLDWriterGraphRIOTFactory wfactory2 = new JsonLDWriterGraphRIOTFactory();
        RDFWriterRegistry.register((RDFFormat)JSONLD_FORMAT_PRETTY, (WriterGraphRIOTFactory)wfactory2);
        RDFWriterRegistry.register((RDFFormat)JSONLD_FORMAT_FLAT, (WriterGraphRIOTFactory)wfactory2);
        IO_Jena.registerForModelWrite((String)JSONLD.getName(), JsonLDRDFWriter.class);
    }

    static {
        JenaJSONLD.init();
    }

    public static class JsonLDRDFWriter
    extends RDFWriterRIOT {
        public JsonLDRDFWriter() {
            super(JSONLD.getName());
        }
    }

    public static class JsonLDRDFReader
    extends RDFReaderRIOT {
        public JsonLDRDFReader() {
            super(JSONLD.getName());
        }
    }

    public static class JsonLDWriterGraphRIOTFactory
    implements WriterGraphRIOTFactory {
        public WriterGraphRIOT create(RDFFormat syntaxForm) {
            return RiotLib.adapter((WriterDatasetRIOT)new JsonLDWriter(syntaxForm));
        }
    }

    public static class JsonLDWriterDatasetRIOTFactory
    implements WriterDatasetRIOTFactory {
        public WriterDatasetRIOT create(RDFFormat syntaxForm) {
            return new JsonLDWriter(syntaxForm);
        }
    }

    public static final class JsonLDReaderRIOTFactory
    implements ReaderRIOTFactory {
        public ReaderRIOT create(Lang language) {
            return new JsonLDReader();
        }
    }
}

