/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.sesame;

import com.github.jsonldjava.sesame.SesameJSONLDParserFactory;
import com.github.jsonldjava.sesame.SesameJSONLDWriterFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterTest;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.openrdf.rio.helpers.JSONLDMode;
import org.openrdf.rio.helpers.JSONLDSettings;
import org.openrdf.rio.helpers.StatementCollector;

public class SesameJSONLDWriterTest
extends RDFWriterTest {
    public SesameJSONLDWriterTest() {
        super((RDFWriterFactory)new SesameJSONLDWriterFactory(), (RDFParserFactory)new SesameJSONLDParserFactory());
    }

    @Test
    public void testRoundTrip() throws RDFHandlerException, IOException, RDFParseException {
        String ex = "http://example.org/";
        ValueFactoryImpl vf = new ValueFactoryImpl();
        BNode bnode = vf.createBNode("anon");
        URI uri1 = vf.createURI("http://example.org/", "uri1");
        URI uri2 = vf.createURI("http://example.org/", "uri2");
        Literal plainLit = vf.createLiteral("plain");
        Literal dtLit = vf.createLiteral(1);
        Literal langLit = vf.createLiteral("test", "en");
        Literal litWithNewline = vf.createLiteral("literal with newline\n");
        Literal litWithSingleQuotes = vf.createLiteral("'''some single quote text''' - abc");
        Literal litWithDoubleQuotes = vf.createLiteral("\"\"\"some double quote text\"\"\" - abc");
        Statement st1 = vf.createStatement((Resource)bnode, uri1, (Value)plainLit);
        Statement st2 = vf.createStatement((Resource)uri1, uri2, (Value)langLit, (Resource)uri2);
        Statement st3 = vf.createStatement((Resource)uri1, uri2, (Value)dtLit);
        Statement st4 = vf.createStatement((Resource)uri1, uri2, (Value)litWithNewline);
        Statement st5 = vf.createStatement((Resource)uri1, uri2, (Value)litWithSingleQuotes);
        Statement st6 = vf.createStatement((Resource)uri1, uri2, (Value)litWithDoubleQuotes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)out);
        WriterConfig writerConfig = rdfWriter.getWriterConfig();
        writerConfig.set(BasicWriterSettings.RDF_LANGSTRING_TO_LANG_LITERAL, (Object)true);
        writerConfig.set(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL, (Object)true);
        writerConfig.set(JSONLDSettings.JSONLD_MODE, (Object)JSONLDMode.COMPACT);
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", "http://example.org/");
        rdfWriter.handleStatement(st1);
        rdfWriter.handleStatement(st2);
        rdfWriter.handleStatement(st3);
        rdfWriter.handleStatement(st4);
        rdfWriter.handleStatement(st5);
        rdfWriter.handleStatement(st6);
        rdfWriter.endRDF();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        ParserConfig config = new ParserConfig();
        config.set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        config.set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        rdfParser.setParserConfig(config);
        rdfParser.setValueFactory((ValueFactory)vf);
        LinkedHashModel model = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        rdfParser.parse((InputStream)in, "foo:bar");
        Assert.assertEquals((String)"Unexpected number of namespaces", (long)1L, (long)model.getNamespaces().size());
        Assert.assertEquals((String)"Unexpected number of statements", (long)6L, (long)model.size());
        Model bnodeModel = model.filter(null, uri1, (Value)vf.createLiteral(plainLit.getLabel(), XMLSchema.STRING), new Resource[0]);
        Assert.assertEquals((String)"Blank node was not round-tripped", (long)1L, (long)bnodeModel.size());
        Assert.assertTrue((String)"Blank node was not round-tripped as a blank node", (boolean)(bnodeModel.subjects().iterator().next() instanceof BNode));
        if (rdfParser.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)model.contains((Object)st2));
        } else {
            Assert.assertTrue((boolean)model.contains((Object)vf.createStatement((Resource)uri1, uri2, (Value)langLit)));
        }
        Assert.assertTrue((boolean)model.contains((Object)st3));
        Assert.assertTrue((String)"missing statement with literal ending on newline", (boolean)model.contains((Object)vf.createStatement((Resource)uri1, uri2, (Value)vf.createLiteral(litWithNewline.getLabel(), XMLSchema.STRING))));
        Assert.assertTrue((String)"missing statement with single quotes", (boolean)model.contains((Object)vf.createStatement((Resource)uri1, uri2, (Value)vf.createLiteral(litWithSingleQuotes.getLabel(), XMLSchema.STRING))));
        Assert.assertTrue((String)"missing statement with single quotes", (boolean)model.contains((Object)vf.createStatement((Resource)uri1, uri2, (Value)vf.createLiteral(litWithDoubleQuotes.getLabel(), XMLSchema.STRING))));
    }
}

