/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.sesame;

import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.ParseErrorLogger;
import org.openrdf.rio.helpers.RDFParserHelper;
import org.openrdf.rio.helpers.StatementCollector;

public class SesameTripleCallback
implements JsonLdTripleCallback {
    private ValueFactory vf;
    private RDFHandler handler;
    private ParserConfig parserConfig;
    private final ParseErrorListener parseErrorListener;

    public SesameTripleCallback() {
        this((RDFHandler)new StatementCollector((Collection)new LinkedHashModel()));
    }

    public SesameTripleCallback(RDFHandler nextHandler) {
        this(nextHandler, (ValueFactory)ValueFactoryImpl.getInstance());
    }

    public SesameTripleCallback(RDFHandler nextHandler, ValueFactory vf) {
        this(nextHandler, vf, new ParserConfig(), (ParseErrorListener)new ParseErrorLogger());
    }

    public SesameTripleCallback(RDFHandler nextHandler, ValueFactory vf, ParserConfig parserConfig, ParseErrorListener parseErrorListener) {
        this.handler = nextHandler;
        this.vf = vf;
        this.parserConfig = parserConfig;
        this.parseErrorListener = parseErrorListener;
    }

    private void triple(String s, String p, String o, String graph) {
        if (s == null || p == null || o == null) {
            return;
        }
        Statement result = graph == null ? this.vf.createStatement(this.createResource(s), this.vf.createURI(p), (Value)this.createResource(o)) : this.vf.createStatement(this.createResource(s), this.vf.createURI(p), (Value)this.createResource(o), this.createResource(graph));
        if (this.handler != null) {
            try {
                this.handler.handleStatement(result);
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Resource createResource(String resource) {
        if (resource.equals("_:")) {
            return this.vf.createBNode();
        }
        if (resource.startsWith("_:")) {
            return this.vf.createBNode(resource.substring(2));
        }
        return this.vf.createURI(resource);
    }

    private void triple(String s, String p, String value, String datatype, String language, String graph) {
        Literal object;
        if (s == null || p == null || value == null) {
            return;
        }
        Resource subject = this.createResource(s);
        URI predicate = this.vf.createURI(p);
        URI datatypeURI = datatype == null ? null : this.vf.createURI(datatype);
        try {
            object = RDFParserHelper.createLiteral((String)value, (String)language, (URI)datatypeURI, (ParserConfig)this.getParserConfig(), (ParseErrorListener)this.getParserErrorListener(), (ValueFactory)this.getValueFactory());
        }
        catch (RDFParseException e) {
            throw new RuntimeException(e);
        }
        Statement result = graph == null ? this.vf.createStatement(subject, predicate, (Value)object) : this.vf.createStatement(subject, predicate, (Value)object, this.createResource(graph));
        if (this.handler != null) {
            try {
                this.handler.handleStatement(result);
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ParseErrorListener getParserErrorListener() {
        return this.parseErrorListener;
    }

    public RDFHandler getHandler() {
        return this.handler;
    }

    public void setHandler(RDFHandler handler) {
        this.handler = handler;
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    public ValueFactory getValueFactory() {
        return this.vf;
    }

    public void setValueFactory(ValueFactory vf) {
        this.vf = vf;
    }

    /*
     * WARNING - void declaration
     */
    public Object call(RDFDataset dataset) {
        if (this.handler != null) {
            for (Map.Entry entry : dataset.getNamespaces().entrySet()) {
                try {
                    this.handler.handleNamespace((String)entry.getKey(), (String)entry.getValue());
                }
                catch (RDFHandlerException e) {
                    throw new RuntimeException("Failed handling namespace", e);
                }
            }
        }
        for (String string : dataset.keySet()) {
            List quads = dataset.getQuads(string);
            if ("@default".equals(string)) {
                Object var3_6 = null;
            }
            for (RDFDataset.Quad quad : quads) {
                void var3_7;
                if (quad.getObject().isLiteral()) {
                    this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), quad.getObject().getDatatype(), quad.getObject().getLanguage(), (String)var3_7);
                    continue;
                }
                this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), (String)var3_7);
            }
        }
        return this.getHandler();
    }
}

