/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.sesame;

import com.github.jsonldjava.sesame.SesameJSONLDParserFactory;
import com.github.jsonldjava.sesame.SesameJSONLDWriterFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterTest;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.JSONLDMode;
import org.openrdf.rio.helpers.JSONLDSettings;
import org.openrdf.rio.helpers.StatementCollector;

public class SesameJSONLDWriterTest
extends RDFWriterTest {
    public SesameJSONLDWriterTest() {
        super((RDFWriterFactory)new SesameJSONLDWriterFactory(), (RDFParserFactory)new SesameJSONLDParserFactory());
    }

    protected void setupWriterConfig(WriterConfig config) {
        config.set(JSONLDSettings.JSONLD_MODE, (Object)JSONLDMode.COMPACT);
    }

    protected void setupParserConfig(ParserConfig config) {
        config.set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        config.set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
    }

    @Test
    @Ignore(value="Default RDFWriter.getWriterConfig doesn't use JSONLDMode.COMPACT, so namespaces are not preserved")
    public void testPerformance() throws Exception {
    }

    @Test
    @Ignore(value="Default RDFWriter.getWriterConfig doesn't use JSONLDMode.COMPACT, so namespaces are not preserved")
    public void testRoundTrip() throws Exception {
    }

    @Test
    @Ignore(value="Default RDFWriter.getWriterConfig doesn't use JSONLDMode.COMPACT, so namespaces are not preserved")
    public void testRoundTripPreserveBNodeIds() throws Exception {
    }

    @Test
    public void testRoundTripNamespaces() throws Exception {
        String exNs = "http://example.org/";
        URI uri1 = this.vf.createURI(exNs, "uri1");
        URI uri2 = this.vf.createURI(exNs, "uri2");
        Literal plainLit = this.vf.createLiteral("plain", XMLSchema.STRING);
        Statement st1 = this.vf.createStatement((Resource)uri1, uri2, (Value)plainLit);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)out);
        rdfWriter.getWriterConfig().set(JSONLDSettings.JSONLD_MODE, (Object)JSONLDMode.COMPACT);
        rdfWriter.handleNamespace("ex", exNs);
        rdfWriter.startRDF();
        rdfWriter.handleStatement(st1);
        rdfWriter.endRDF();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        ParserConfig config = new ParserConfig();
        config.set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        config.set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        rdfParser.setParserConfig(config);
        rdfParser.setValueFactory(this.vf);
        LinkedHashModel model = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        rdfParser.parse((InputStream)in, "foo:bar");
        Assert.assertEquals((String)("Unexpected number of statements, found " + model.size()), (long)1L, (long)model.size());
        Assert.assertTrue((String)"missing namespaced statement", (boolean)model.contains((Object)st1));
        if (rdfParser.getRDFFormat().supportsNamespaces()) {
            Assert.assertTrue((String)("Expected at least one namespace, found " + model.getNamespaces().size()), (model.getNamespaces().size() >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)exNs, (Object)model.getNamespace("ex").getName());
        }
    }
}

