package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.classloader.MemoryClassLoader;

import java.io.File;
import java.io.IOException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * JavaDynamicUtils
 *
 * @author huangchengkang
 * @date 2021/9/18 1:34
 */
public class JavaDynamicUtils {

    public static Class<?> forClass(File file)
            throws ClassNotFoundException, IOException {
        String javaSrc = FileUtils.readFileToString(file);
        return forClass(javaSrc);
    }
    public static Class<?> forClass(String javaSrc)
            throws ClassNotFoundException {
        MemoryClassLoader loader = MemoryClassLoader.getInstance();
        return loader.registerJava(javaSrc);
    }
    public static Class<?> forClass(String className, String javaSrc)
            throws ClassNotFoundException {
        MemoryClassLoader loader = MemoryClassLoader.getInstance();
        return loader.registerJava(className, javaSrc);
    }

    public static Object invoke(File file){
        try {
            return invoke(FileUtils.readFileToString(file), Collections.emptyMap());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    public static Object invoke(String javaSrc){
        return invoke(javaSrc, Collections.emptyMap());
    }
    public static <T> T invokeAs(String javaSrc){
        return (T) invoke(javaSrc, Collections.emptyMap());
    }

    public static <T> T invoke(String javaSrc, Class<T> returnClass){
        return invoke(javaSrc, Collections.emptyMap(), returnClass);
    }

    public static Object invoke(String javaSrc, Map<String,Object> params){
        return invoke(javaSrc, params, Object.class);
    }

    public static <T> T invokeAs(String javaSrc, Map<String,Object> params){
        return (T) invoke(javaSrc, params);
    }

    public static <T> T invoke(String javaSrc, Map<String,Object> params, Class<T> returnClass){
        String finalJavaSrc = javaSrc;
        if (!javaSrc.contains(" class ")){
            String returnClassName = Objects.isNull(returnClass) ? Object.class.getName() : returnClass.getName();
            String className = String.format("DynamicHandler_%s", Md5Utils.md5(javaSrc));
            String classFormat = "" +
                    "import com.github.kancyframework.springx.utils.*;\n" +
                    "import com.github.kancyframework.springx.classloader.*;\n\n" +
                    "import java.text.*;\n" +
                    "import java.net.*;\n" +
                    "import java.util.*;\n" +
                    "import java.io.*;\n" +
                    "import java.nio.charset.*;\n" +
                    "import java.math.*;\n" +
                    "import java.time.*;\n" +
                    "import java.lang.reflect.*;\n\n";
            List<String> imports = getImports(javaSrc);
            String notImportJavaSrc = javaSrc;
            if (!imports.isEmpty()){
                for (String anImport : imports) {
                    classFormat += (anImport + "\n");
                    notImportJavaSrc = notImportJavaSrc.replace(anImport, "");
                }
                notImportJavaSrc = notImportJavaSrc.replaceAll("\n+", "\n");
            }

            classFormat +=
                    "public class %s implements DynamicHandler<%s> {\n" +
                    "\n" +
                    "    @Override\n" +
                    "    public %s handle(Map<String, Object> context) {\n" +
                    "        %s\n" +
                    "    }\n" +
                    "}";

            if (javaSrc.contains("return ")){
                finalJavaSrc = String.format(classFormat, className,returnClassName, returnClassName, notImportJavaSrc);
            }else {
                finalJavaSrc = String.format(classFormat, className,returnClassName, returnClassName, notImportJavaSrc + "\n\nreturn null;");
            }
        }
        return (T) invoke(finalJavaSrc, "handle", params);
    }

    public static Object invoke(String javaSrc, String methodName, Object ... args){
        try {
            Class<?> aClass = forClass(javaSrc);
            Object instance = aClass.newInstance();
            return ReflectionUtils.invokeMethod(instance, methodName, args);
        } catch (Exception e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static Object invokeStatic(String javaSrc, String methodName, Object ... args) {
        try {
            Class<?> aClass = forClass(javaSrc);
            return ReflectionUtils.invokeStaticMethod(aClass.getName(), methodName, args);
        } catch (Exception e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    private static List<String> getImports(String src){
        Pattern pattern = Pattern.compile("(import\\s+[a-zA-Z_.0-9]+;)");
        Matcher matcher = pattern.matcher(src);

        List<String> imports = new ArrayList<>();
        while (matcher.find()) {
            imports.add(matcher.group(1));
        }
        return imports;
    }
}
