/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.Base64Utils;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesUtils {
    private static final String S_KEY = "UalUV^u@F$2ZStxE";
    private static final String IV_PARAMETER = "lr60I@gpel#IIkSG";
    private Cipher encryptCipher;
    private Cipher decryptCipher;

    private AesUtils() {
        this(S_KEY, IV_PARAMETER);
    }

    private AesUtils(String S_KEY) {
        this.init(S_KEY, IV_PARAMETER);
    }

    private AesUtils(String S_KEY, String IV_PARAMETER) {
        this.init(S_KEY, IV_PARAMETER);
    }

    private static AesUtils getInstance() {
        return AesHolder.instance;
    }

    public static AesUtils getInstance(String key) {
        return new AesUtils(key);
    }

    public static AesUtils getInstance(String key, String ivParameter) {
        return new AesUtils(key, ivParameter);
    }

    public String aesDecrypt(String sSrc) {
        return this.aesDecrypt(sSrc, false);
    }

    public static String decrypt(String sSrc) {
        return AesUtils.getInstance().aesDecrypt(sSrc);
    }

    public String aesDecrypt(String sSrc, boolean isUrl) {
        try {
            byte[] base64Encrypt = Base64Utils.decodeString(isUrl ? AesUtils.decodeSlash(sSrc) : sSrc);
            byte[] original = this.decryptCipher.doFinal(base64Encrypt);
            String originalString = new String(original, "utf-8");
            return originalString;
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public static String decrypt(String sSrc, boolean isUrl) {
        return AesUtils.getInstance().aesDecrypt(sSrc, isUrl);
    }

    public String aesEncrypt(String sSrc, boolean isUrl) {
        try {
            byte[] encrypted = this.encryptCipher.doFinal(sSrc.getBytes("utf-8"));
            String encode = Base64Utils.encodeBytes(encrypted);
            return isUrl ? AesUtils.encodeSlash(encode) : AesUtils.trimLineSeparator(encode);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static String encrypt(String sSrc, boolean isUrl) {
        return AesUtils.getInstance().aesEncrypt(sSrc, isUrl);
    }

    public String aesEncrypt(String sSrc) {
        return this.aesEncrypt(sSrc, false);
    }

    public static String encrypt(String sSrc) {
        return AesUtils.getInstance().aesEncrypt(sSrc);
    }

    private static String trimLineSeparator(String sSrc) {
        if (sSrc != null) {
            return sSrc.replaceAll("\\r", "").replaceAll("\\n", "");
        }
        return null;
    }

    private static String encodeSlash(String sSrc) {
        if (sSrc != null) {
            return sSrc.replaceAll("/", "_").replaceAll("\\+", "-").replaceAll("\\r", "").replaceAll("\\n", "");
        }
        return null;
    }

    private static String decodeSlash(String sSrc) {
        if (sSrc != null) {
            return sSrc.replaceAll("_", "/").replaceAll("\\-", "+");
        }
        return null;
    }

    private void init(String strKey, String ivParameter) {
        try {
            byte[] raw = strKey.getBytes("ASCII");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            IvParameterSpec iv = new IvParameterSpec(ivParameter.getBytes());
            this.encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.encryptCipher.init(1, (Key)skeySpec, iv);
            this.decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.decryptCipher.init(2, (Key)skeySpec, iv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class AesHolder {
        public static final AesUtils instance = new AesUtils();

        private AesHolder() {
        }
    }
}

