/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.annotation.AliasFor;
import com.github.kancyframework.springx.utils.BeanUtils;
import com.github.kancyframework.springx.utils.ReflectionUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AnnotationUtils {
    private static final Map<String, Annotation> annotationCache = new ConcurrentHashMap<String, Annotation>();

    public static <T extends Annotation> T findAnnotation(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        Class cls;
        Annotation[] annotations;
        String annotationCacheKey = String.format("%s@%s", annotatedElement, annotationClass.getName());
        if (annotationCache.containsKey(annotationCacheKey)) {
            Annotation annotation = annotationCache.get(annotationCacheKey);
            if (Objects.isNull(annotation)) {
                return null;
            }
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        if (annotatedElement.isAnnotationPresent(annotationClass)) {
            T targetAnnotation = annotatedElement.getAnnotation(annotationClass);
            T annotationProxy = AnnotationUtils.getAnnotationProxy(annotationClass, targetAnnotation, targetAnnotation);
            annotationCache.putIfAbsent(annotationCacheKey, (Annotation)annotationProxy);
            return annotationProxy;
        }
        T targetAnnotation = null;
        for (Annotation dataAnnotation : annotations = annotatedElement.getAnnotations()) {
            String packageName = dataAnnotation.annotationType().getPackage().getName();
            if (packageName.startsWith("java.lang")) continue;
            targetAnnotation = dataAnnotation.annotationType().getAnnotation(annotationClass);
            if (targetAnnotation == null) {
                targetAnnotation = AnnotationUtils.findAnnotation(dataAnnotation.annotationType(), annotationClass);
            }
            if (targetAnnotation == null) continue;
            T annotationProxy = AnnotationUtils.getAnnotationProxy(annotationClass, targetAnnotation, dataAnnotation);
            annotationCache.putIfAbsent(annotationCacheKey, (Annotation)annotationProxy);
            return annotationProxy;
        }
        if (annotatedElement instanceof Class && Objects.nonNull((cls = (Class)Class.class.cast(annotatedElement)).getSuperclass())) {
            T annotation = AnnotationUtils.findAnnotation(cls.getSuperclass(), annotationClass);
            if (Objects.nonNull(annotation)) {
                annotationCache.putIfAbsent(annotationCacheKey, (Annotation)annotation);
            }
            return annotation;
        }
        return null;
    }

    public static <T> T getProperty(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationClass, String propertyName, Class<T> valueType) {
        Annotation annotation = AnnotationUtils.findAnnotation(annotatedElement, annotationClass);
        if (Objects.isNull(annotation)) {
            return null;
        }
        return (T)ReflectionUtils.invokeMethod((Object)annotation, propertyName, new Object[0]);
    }

    public static <T> T getProperty(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationClass, String propertyName) {
        return (T)AnnotationUtils.getProperty(annotatedElement, annotationClass, propertyName, Object.class);
    }

    public static <T> T getValue(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationClass, Class<T> valueType) {
        return AnnotationUtils.getProperty(annotatedElement, annotationClass, "value", valueType);
    }

    public static <T> T getValue(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationClass) {
        return (T)AnnotationUtils.getValue(annotatedElement, annotationClass, Object.class);
    }

    public static <T> T toBean(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationClass, Class<T> propertyClass) {
        return AnnotationUtils.toBean(AnnotationUtils.findAnnotation(annotatedElement, annotationClass), propertyClass);
    }

    public static Map<String, Object> toMap(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.toMap(AnnotationUtils.findAnnotation(annotatedElement, annotationClass));
    }

    public static <T> T toBean(Annotation annotation, Class<T> propertyClass) {
        return BeanUtils.mapToBean(AnnotationUtils.toMap(annotation), propertyClass);
    }

    public static Map<String, Object> toMap(Annotation annotation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReflectionUtils.doWithMethods(annotation.getClass(), method -> {
            Object value = ReflectionUtils.invokeMethod((Object)annotation, method.getName(), new Object[0]);
            map.put(method.getName(), value);
        });
        return map;
    }

    private static <T extends Annotation> T getAnnotationProxy(Class<T> annotationClass, T targetAnnotation, Annotation dataAnnotation) {
        Method[] annotationMethods;
        HashMap<String, Method> dataAnnotationMethodMap = new HashMap<String, Method>();
        for (Method annotationMethod : annotationMethods = dataAnnotation.annotationType().getDeclaredMethods()) {
            if (!annotationMethod.isAnnotationPresent(AliasFor.class)) continue;
            AliasFor aliasFor = annotationMethod.getAnnotation(AliasFor.class);
            String attributeName = aliasFor.value();
            if (StringUtils.isBlank(attributeName)) {
                attributeName = aliasFor.attribute();
            }
            if (StringUtils.isBlank(attributeName)) {
                attributeName = annotationMethod.getName();
            }
            String methodKey = String.format("%s@%s", aliasFor.annotation().getName(), attributeName);
            dataAnnotationMethodMap.put(methodKey, annotationMethod);
        }
        return (T)((Annotation)annotationClass.cast(AnnotationUtils.createAnnotationProxy(targetAnnotation, dataAnnotation, dataAnnotationMethodMap)));
    }

    private static Object createAnnotationProxy(Annotation targetAnnotation, Annotation dataAnnotation, Map<String, Method> dataAnnotationMethodMap) {
        Class<? extends Annotation> annotationType = targetAnnotation.annotationType();
        Class[] exposedInterfaces = new Class[]{annotationType};
        return Proxy.newProxyInstance(targetAnnotation.getClass().getClassLoader(), exposedInterfaces, (proxy, method, args) -> {
            Method targetMethod = null;
            if (targetAnnotation == dataAnnotation) {
                Object invoke = method.invoke((Object)targetAnnotation, new Object[0]);
                if (!Objects.equals(invoke, "")) return invoke;
                targetMethod = (Method)dataAnnotationMethodMap.get(String.format("%s@%s", Annotation.class.getName(), method.getName()));
            } else {
                String methodKey = String.format("%s@%s", targetAnnotation.annotationType().getName(), method.getName());
                targetMethod = (Method)dataAnnotationMethodMap.get(methodKey);
                if (Objects.isNull(targetMethod)) {
                    methodKey = String.format("%s@%s", Annotation.class.getName(), method.getName());
                    targetMethod = (Method)dataAnnotationMethodMap.get(methodKey);
                }
            }
            if (!Objects.nonNull(targetMethod)) return method.invoke((Object)targetAnnotation, args);
            return targetMethod.invoke((Object)dataAnnotation, new Object[0]);
        });
    }
}

