/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.ClassUtils;
import com.github.kancyframework.springx.utils.CollectionUtils;
import com.github.kancyframework.springx.utils.ObjectUtils;
import com.github.kancyframework.springx.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class BeanUtils {
    public static <T> T copyProperties(Object source, Class<T> targetClass) {
        T target = null;
        try {
            target = ClassUtils.newObject(targetClass, new Object[0]);
            BeanUtils.copyProperties(source, target);
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException(e);
        }
        return target;
    }

    public static void copyProperties(Object source, Object target) {
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        ReflectionUtils.doWithFields(targetClass, field -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            Field sourceField = ReflectionUtils.findField(sourceClass, field.getName(), field.getType());
            if (Objects.nonNull(sourceField)) {
                ReflectionUtils.makeAccessible(field);
                ReflectionUtils.makeAccessible(sourceField);
                ReflectionUtils.setField(field, target, ReflectionUtils.getField(sourceField, source));
            }
        });
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        T bean = null;
        try {
            bean = ClassUtils.newObject(beanClass, new Object[0]);
            BeanUtils.mapToBean(map, bean);
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException(e);
        }
        return bean;
    }

    public static void mapToBean(Map<String, Object> source, Object target) {
        if (CollectionUtils.isEmpty(source)) {
            return;
        }
        Class<?> targetClass = target.getClass();
        ReflectionUtils.doWithFields(targetClass, field -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            Object fieldValue = source.get(field.getName());
            if (Objects.nonNull(fieldValue = ObjectUtils.cast(fieldValue, field.getType()))) {
                ReflectionUtils.makeAccessible(field);
                ReflectionUtils.setField(field, target, fieldValue);
            }
        });
    }

    public static Map<String, Object> beanToMap(Object bean) {
        if (Objects.isNull(bean)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanUtils.beanToMap(bean, map);
        return map;
    }

    public static void beanToMap(Object bean, Map<String, Object> map) {
        Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithFields(beanClass, field -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            ReflectionUtils.makeAccessible(field);
            map.put(field.getName(), field.get(bean));
        });
    }
}

