/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mozilla.universalchardet.UniversalDetector;

public class CharsetUtils {
    public static String parseFileEncoding(String filePath) {
        return CharsetUtils.parseFileEncoding(new File(filePath));
    }

    public static String parseFileEncoding(File file) {
        String encoding = Charset.defaultCharset().displayName();
        if (file == null || !file.isFile() || !file.exists()) {
            return encoding;
        }
        try {
            encoding = UniversalDetector.detectCharset((File)file);
        }
        catch (IOException e) {
            return encoding;
        }
        return encoding;
    }

    public static Charset parseFileCharset(File file) {
        return Charset.forName(CharsetUtils.parseFileEncoding(file));
    }

    public static String parseCharset(byte[] bytes) {
        return CharsetUtils.parseCharset(new ByteArrayInputStream(bytes));
    }

    public static String parseCharset(InputStream inputStream) {
        String encoding = Charset.defaultCharset().displayName();
        try {
            encoding = UniversalDetector.detectCharset((InputStream)inputStream);
        }
        catch (IOException e) {
            return encoding;
        }
        return encoding;
    }
}

