/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.log.Logger;
import com.github.kancyframework.springx.log.LoggerFactory;
import com.github.kancyframework.springx.utils.ObjectUtils;
import com.github.kancyframework.springx.utils.ReflectionUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public abstract class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static Set<Class<?>> getClassesByPackageName(String packageName, boolean recursively) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ClassUtils.getClassesByPackageName(classLoader, packageName, recursively);
    }

    public static Set<Class<?>> getClassesByPackageName(ClassLoader classLoader, String packageName, boolean recursively) throws IOException {
        HashSet classes = new HashSet();
        try {
            Enumeration<URL> urls = classLoader.getResources(packageName.replace(".", "/"));
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String packagePath = url.getPath().replaceAll(" ", "");
                    ClassUtils.getClassesInPackageUsingFileProtocol(classes, classLoader, packagePath, packageName, recursively);
                    continue;
                }
                if ("jar".equals(protocol)) {
                    ClassUtils.getClassesInPackageUsingJarProtocol(classes, classLoader, url, packageName, recursively);
                    continue;
                }
                log.warn(String.format("protocol[%s] not supported!", protocol), new Object[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return classes;
    }

    private static void getClassesInPackageUsingJarProtocol(Set<Class<?>> classes, ClassLoader classLoader, URL url, String packageName, boolean recursively) throws IOException {
        String packagePath = packageName.replace(".", "/");
        log.info("start scan {}", new Object[]{url});
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        if (jarURLConnection != null) {
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(packagePath) || !jarEntryName.endsWith(".class") || !recursively && jarEntryName.substring(packagePath.length() + 1).contains("/")) continue;
                log.debug(jarEntryName, new Object[0]);
                String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                classes.add(ClassUtils.loadClass(className, false, classLoader));
            }
        }
        log.info("  end scan {}", new Object[]{url});
    }

    private static void getClassesInPackageUsingFileProtocol(Set<Class<?>> classes, ClassLoader classLoader, String packagePath, String packageName, boolean recursively) {
        File[] files;
        for (File file2 : files = new File(packagePath).listFiles(file -> file.isFile() && file.getName().endsWith(".class") || file.isDirectory())) {
            String fileName = file2.getName();
            if (file2.isFile()) {
                String className = fileName.substring(0, fileName.lastIndexOf("."));
                if (!StringUtils.isEmpty(packageName)) {
                    className = packageName + "." + className;
                }
                classes.add(ClassUtils.loadClass(className, false, classLoader));
                continue;
            }
            if (!recursively) continue;
            String subPackagePath = fileName;
            if (!StringUtils.isEmpty(subPackagePath)) {
                subPackagePath = packagePath + "/" + subPackagePath;
            }
            String subPackageName = fileName;
            if (!StringUtils.isEmpty(packageName)) {
                subPackageName = packageName + "." + subPackageName;
            }
            ClassUtils.getClassesInPackageUsingFileProtocol(classes, classLoader, subPackagePath, subPackageName, recursively);
        }
    }

    public static Class<?>[] loadClasses(String ... classNames) {
        List<Class> classList = Arrays.stream(classNames).map(c -> ClassUtils.loadClass(c, true, ClassUtils.class.getClassLoader())).collect(Collectors.toList());
        return classList.toArray(new Class[0]);
    }

    public static boolean hasClass(String className) {
        try {
            Class<?> aClass = ClassUtils.loadClass(className);
            if (Objects.nonNull(aClass)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Class<?> loadClass(String className) {
        return ClassUtils.loadClass(className, true, ClassUtils.class.getClassLoader());
    }

    public static Class<?> loadClass(String className, Boolean isInitialized, ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, isInitialized, classLoader);
        }
        catch (ClassNotFoundException e) {
            ReflectionUtils.handleReflectionException(e);
        }
        return clazz;
    }

    public static <T> T newObject(Class<T> cls, Object ... args) {
        Class[] paramClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            paramClasses[i] = args[i].getClass();
        }
        try {
            Constructor constructor = ClassUtils.getDeclaredConstructor(cls, paramClasses);
            ReflectionUtils.makeAccessible(constructor);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException(e);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object newObject(String className, Object ... args) {
        Class<?>[] classes = ClassUtils.loadClasses(className);
        if (classes.length > 0) {
            return ClassUtils.newObject(classes[0], args);
        }
        return null;
    }

    public static <T> Constructor getDeclaredConstructor(Class<T> cls, Class<?>[] paramClasses) throws NoSuchMethodException {
        Constructor<Object> constructor = null;
        try {
            constructor = ReflectionUtils.accessibleConstructor(cls, paramClasses);
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors;
            block2: for (Constructor<?> c : constructors = cls.getDeclaredConstructors()) {
                if (c.getParameterCount() != paramClasses.length) continue;
                constructor = c;
                Class<?>[] parameterTypes = c.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (ClassUtils.isAssignableFrom(parameterTypes[i], paramClasses[i])) continue;
                    constructor = null;
                    continue block2;
                }
            }
        }
        if (Objects.isNull(constructor)) {
            throw new NoSuchMethodException("Not found available constructor");
        }
        return constructor;
    }

    public static boolean isAnnotationPresentOnClass(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return clazz.isAnnotationPresent(annotationClass);
    }

    public static boolean isAnnotationPresentOnMethod(Class<?> clazz, Class<? extends Annotation> annotationClass, String methodName, Class ... paramTypes) {
        Method method = ReflectionUtils.findMethod(clazz, methodName, paramTypes);
        return Objects.nonNull(method) && method.isAnnotationPresent(annotationClass);
    }

    @Deprecated
    public static <T> Class<T> getGenericType(Class<?> srcClass) {
        return ClassUtils.getGenericType(srcClass, 0);
    }

    @Deprecated
    public static <T> Class<T> getGenericType(Class<?> srcClass, int genericIndex) {
        return (Class)((ParameterizedType)srcClass.getGenericSuperclass()).getActualTypeArguments()[genericIndex];
    }

    public static <T> Class<T> getSupperGenericType(Class<?> srcClass) {
        return ClassUtils.getGenericType(srcClass, 0);
    }

    public static <T> Class<T> getSupperGenericType(Class<?> srcClass, int genericIndex) {
        return (Class)((ParameterizedType)srcClass.getGenericSuperclass()).getActualTypeArguments()[genericIndex];
    }

    public static <T> Class<T> findSupperGenericType(Class<?> srcClass, Class<T> type) {
        return ClassUtils.findGenericType(srcClass, type, false);
    }

    public static <T> Class<T> findGenericType(Class<?> srcClass, Class<T> type) {
        return ClassUtils.findGenericType(srcClass, type, true);
    }

    public static <T> Class<T> findGenericType(Class<?> srcClass, Class<T> type, boolean searchInterface) {
        Type genericSuperclass = srcClass.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            Class<T> interfaceGenericType;
            Type[] actualTypeArguments;
            for (Type actualTypeArgument : actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments()) {
                if (!type.isAssignableFrom((Class)actualTypeArgument)) continue;
                return (Class)actualTypeArgument;
            }
            if (searchInterface && Objects.nonNull(interfaceGenericType = ClassUtils.findInterfaceGenericType(srcClass, type))) {
                return interfaceGenericType;
            }
            return ClassUtils.findGenericType((Class)((ParameterizedType)genericSuperclass).getRawType(), type, searchInterface);
        }
        if (Objects.equals(genericSuperclass, Object.class)) {
            Class<T> interfaceGenericType;
            if (searchInterface && Objects.nonNull(interfaceGenericType = ClassUtils.findInterfaceGenericType(srcClass, type))) {
                return interfaceGenericType;
            }
            return null;
        }
        return ClassUtils.findGenericType((Class)genericSuperclass, type, searchInterface);
    }

    public static <T> Class<T> getInterfaceGenericType(Class<?> srcClass) {
        return (Class)((ParameterizedType)srcClass.getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }

    public static <T> Class<T> findInterfaceGenericType(Class<?> srcClass, Class<T> type) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = srcClass.getGenericInterfaces()) {
            Type[] actualTypeArguments;
            if (!(genericInterface instanceof ParameterizedType)) continue;
            for (Type actualTypeArgument : actualTypeArguments = ((ParameterizedType)genericInterface).getActualTypeArguments()) {
                if (!type.isAssignableFrom((Class)actualTypeArgument)) continue;
                return (Class)actualTypeArgument;
            }
        }
        return null;
    }

    public static <T> Class<T> getInterfaceGenericType(Class<?> srcClass, int genericIndex) {
        return (Class)((ParameterizedType)srcClass.getGenericInterfaces()[0]).getActualTypeArguments()[genericIndex];
    }

    public static <T> Class<T> getInterfaceGenericType(Class<?> srcClass, int interfaceIndex, int genericIndex) {
        return (Class)((ParameterizedType)srcClass.getGenericInterfaces()[interfaceIndex]).getActualTypeArguments()[genericIndex];
    }

    public static boolean isAssignableFrom(Class<?> supperClass, Class<?> subClass) {
        return supperClass.isAssignableFrom(subClass);
    }

    public static boolean isBooleanType(Class<?> clazz) {
        return Objects.equals(clazz, Boolean.TYPE) || Objects.equals(clazz, Boolean.class);
    }

    public static boolean isBaseType(Class<?> clazz) {
        return ObjectUtils.equalsAny(clazz, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE);
    }

    public static boolean isNumber(Class<?> clazz) {
        return ClassUtils.isAssignableFrom(Number.class, clazz) || ObjectUtils.equalsAny(clazz, Long.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE);
    }

    public static boolean isString(Class<?> clazz) {
        return ClassUtils.isAssignableFrom(String.class, clazz);
    }

    public static boolean isDate(Class<?> clazz) {
        return ClassUtils.isAssignableFrom(Date.class, clazz);
    }

    public static boolean isEnum(Class<?> clazz) {
        return Objects.nonNull(clazz) && clazz.isEnum();
    }
}

