/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class CollectionUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String[] EMPTY_STR_ARRAY = new String[0];

    public static boolean isEmpty(Collection<?> collection) {
        return Objects.isNull(collection) || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static Object[] toArray(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] objects = new Object[collection.size()];
        int index = 0;
        for (Object item : collection) {
            objects[index++] = item;
        }
        return objects;
    }

    public static String[] toStrArray(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return EMPTY_STR_ARRAY;
        }
        String[] objects = new String[collection.size()];
        int index = 0;
        for (Object item : collection) {
            objects[index++] = Objects.isNull(item) ? null : String.valueOf(item);
        }
        return objects;
    }

    public static <T> List<T> toList(T[] objects) {
        return Arrays.stream(objects).collect(Collectors.toList());
    }

    public static <T> Set<T> toSet(T[] objects) {
        return Arrays.stream(objects).collect(Collectors.toSet());
    }

    public static <T> List<T> newArrayList(T ... objects) {
        return Arrays.stream(objects).collect(Collectors.toList());
    }

    public static <T> Set<T> newHashSet(T ... objects) {
        return Arrays.stream(objects).collect(Collectors.toSet());
    }

    public static <K, V> Map<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> newHashMap(Object ... objects) {
        Assert.isTrue(objects.length % 2 == 0, "\u53c2\u6570\u503c\u5fc5\u987b\u4e3a\u5076\u6570");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int keyIndex = 0; keyIndex < objects.length; ++keyIndex) {
            map.put(objects[keyIndex], objects[++keyIndex]);
        }
        return map;
    }
}

