/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.CalendarUtils;
import com.github.kancyframework.springx.utils.DurationStyle;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Objects;

public abstract class DateUtils {
    public static String getDatePathStr(LocalDate date) {
        return DateUtils.getDateStr(date, "yyyy/MM/dd");
    }

    public static String getDateStr(LocalDate date) {
        return DateUtils.getDateStr(date, "yyyy-MM-dd");
    }

    public static String getDateStr(LocalDate date, String format) {
        return date.format(DateTimeFormatter.ofPattern(format));
    }

    public static String getDateStr(LocalDateTime date) {
        return DateUtils.getDateStr(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateStr(LocalDateTime date, String format) {
        return date.format(DateTimeFormatter.ofPattern(format));
    }

    public static String getDateStr(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String getDateTimeStr(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String getNowStr(String format) {
        return new SimpleDateFormat(format).format(new Date());
    }

    public static String getNowTimestampStr() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
    }

    public static String getNowStr() {
        return DateUtils.getNowStr(false);
    }

    public static String getNowStr(boolean millis) {
        return new SimpleDateFormat(millis ? "yyyy-MM-dd HH:mm:ss.SSS" : "yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public static String getNowPathStr() {
        return new SimpleDateFormat("yyyy/MM/dd").format(new Date());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    public static Date toDate(Temporal temporal) {
        return Date.from(LocalDateTime.from(temporal).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(String dateStr) {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(dateStr);
        }
        catch (ParseException e1) {
            try {
                date = new SimpleDateFormat("yyyy/MM/dd").parse(dateStr);
            }
            catch (ParseException e2) {
                try {
                    date = new SimpleDateFormat("yyyyMMdd").parse(dateStr);
                }
                catch (ParseException e3) {
                    try {
                        date = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5").parse(dateStr);
                    }
                    catch (ParseException e4) {
                        e4.printStackTrace();
                    }
                }
            }
        }
        return date;
    }

    public static Date toDateTime(String dateStr) {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr);
        }
        catch (ParseException e1) {
            try {
                date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(dateStr);
            }
            catch (ParseException e2) {
                date = DateUtils.toDate(dateStr);
            }
        }
        return date;
    }

    public static Date toTime(String dateStr, String format) {
        try {
            return new SimpleDateFormat(format).parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int getCurrYear() {
        return DateUtils.getYear(new Date());
    }

    public static int getYear(Date date) {
        return Integer.parseInt(DateUtils.getDateStr(date, "yyyy"));
    }

    public static int getCurrMonths() {
        return DateUtils.getMonths(new Date());
    }

    public static int getMonths(Date date) {
        return Integer.parseInt(DateUtils.getDateStr(date, "MM"));
    }

    public static int getCurrDays() {
        return DateUtils.getDays(new Date());
    }

    public static int getDays(Date date) {
        return Integer.parseInt(DateUtils.getDateStr(date, "dd"));
    }

    public static long getCurrTimeSeconds() {
        return DateUtils.getTimeSeconds(new Date());
    }

    public static long getTimeSeconds(Date date) {
        if (Objects.isNull(date)) {
            return 0L;
        }
        return date.getHours() * 60 * 60 + date.getMinutes() * 60 + date.getSeconds();
    }

    public static Date addDuration(Date date, String durationStr) {
        Duration duration = DurationStyle.detectAndParse(durationStr);
        return new Date(date.getTime() + duration.toMillis());
    }

    public static Date subDuration(Date date, String durationStr) {
        Duration duration = DurationStyle.detectAndParse(durationStr);
        return new Date(date.getTime() - duration.toMillis());
    }

    public static Date addSeconds(Date date, int seconds) {
        return new Date(date.getTime() + (long)seconds);
    }

    public static Date addDay(Date date, int days) {
        return new Date(date.getTime() + (long)(days * 24 * 3600 * 1000));
    }

    public static int daysBetween(Date startDate, Date endDate) {
        return CalendarUtils.daysBetween(startDate, endDate);
    }
}

