/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.log.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.WeakHashMap;

public abstract class DebugUtils {
    private static WeakHashMap<Thread, TimeDebug> weakHashMap = new WeakHashMap();

    public static void startPoint() {
        if (!weakHashMap.containsKey(Thread.currentThread())) {
            weakHashMap.put(Thread.currentThread(), new TimeDebug());
        }
    }

    public static void printPoint() {
        DebugUtils.printPoint("C");
    }

    public static void printPoint(String tag) {
        if (weakHashMap.containsKey(Thread.currentThread())) {
            TimeDebug timeDebug = weakHashMap.get(Thread.currentThread());
            timeDebug.setCurrentEndTime(System.currentTimeMillis());
            timeDebug.setTag(tag);
            timeDebug.setMode(1);
            DebugUtils.log(timeDebug.toString());
            timeDebug.setCurrentStartTime(System.currentTimeMillis());
        } else if (Thread.currentThread() != null) {
            DebugUtils.startPoint();
        }
    }

    public static void endPoint() {
        DebugUtils.endPoint("F");
    }

    public static void endPoint(String tag) {
        if (weakHashMap.containsKey(Thread.currentThread())) {
            TimeDebug timeDebug = weakHashMap.get(Thread.currentThread());
            long now = System.currentTimeMillis();
            timeDebug.setCurrentEndTime(now);
            timeDebug.setFinalTime(now);
            timeDebug.setTag(tag);
            timeDebug.setMode(2);
            DebugUtils.log(timeDebug.toString());
            DebugUtils.clearPoint();
        } else {
            DebugUtils.log("\u6ca1\u6709\u521d\u59cb\u5316Debug\u65ad\u70b9\uff0c\u8bf7\u5148\u8c03\u7528\uff1astartPoint() !");
        }
    }

    public static void clearPoint() {
        weakHashMap.remove(Thread.currentThread());
    }

    public static void clearAll() {
        weakHashMap.clear();
    }

    @Deprecated
    private static void log(String msg) {
        Log.debug((String)msg, (Object[])new Object[0]);
    }

    private static String formatConsumeTime(long time) {
        int sec = 1000;
        if (time <= (long)sec) {
            return time + "\u6beb\u79d2";
        }
        int minute = 60 * sec;
        if (time <= (long)minute) {
            return time / (long)sec + "\u79d2" + time % (long)sec + "\u6beb\u79d2";
        }
        int hour = 60 * minute;
        if (time <= (long)hour) {
            return time / (long)minute + "\u5206" + time / (long)sec % 60L + "\u79d2" + time % (long)sec + "\u6beb\u79d2";
        }
        int day = 12 * hour;
        if (time <= 43200000L) {
            return time / (long)hour + "\u5c0f\u65f6" + time / (long)minute % 60L + "\u5206" + time / (long)sec % 60L + "\u79d2" + time % (long)sec + "\u6beb\u79d2";
        }
        return time / (long)day + "\u5929" + time / (long)hour % 12L + "\u5c0f\u65f6" + time / (long)minute % 60L + "\u5206" + time / (long)sec % 60L + "\u79d2" + time % (long)sec + "\u6beb\u79d2";
    }

    private static class TimeDebug {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        private static final int MODE_CURR = 1;
        private static final int MODE_FINAL = 2;
        private long seq;
        private long currentStartTime;
        private long currentEndTime;
        private long originalTime;
        private long finalTime;
        private long sumCount;
        private String tag;
        private int mode;

        public TimeDebug() {
            this.setCurrentStartTime(System.currentTimeMillis());
            this.originalTime = this.currentStartTime;
        }

        public void setFinalTime(long finalTime) {
            this.finalTime = finalTime;
        }

        public void setCurrentStartTime(long currentStartTime) {
            this.currentStartTime = currentStartTime;
        }

        public void setCurrentEndTime(long currentEndTime) {
            this.currentEndTime = currentEndTime;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public String fromCurrentPoint() {
            long consumTime = this.currentEndTime - this.currentStartTime;
            return "===[Debug]===\u300b Point(" + this.seq + ")\uff0c\u5f53\u524d\u7ebf\u7a0b[" + Thread.currentThread().getName() + "]\uff0cTAG[" + this.tag + "]\uff0c\u8017\u65f6[from(" + this.df.format(new Date(this.currentStartTime)) + ")->to(" + this.df.format(new Date(this.currentEndTime)) + ")]\uff1a" + DebugUtils.formatConsumeTime(consumTime) + "\u3010" + consumTime + "\u3011\uff01";
        }

        public String fromEndPoint() {
            if (this.seq == 0L) {
                ++this.seq;
                this.sumCount += this.currentEndTime - this.currentStartTime;
            }
            long consumTime = this.finalTime - this.originalTime;
            return "===[Debug]===\u300b PointCount(" + this.seq + ")\uff0c\u5f53\u524d\u7ebf\u7a0b[" + Thread.currentThread().getName() + "]\uff0cTAG[" + this.tag + "]\uff0c\u4efb\u52a1\u603b\u8017\u65f6[from(" + this.df.format(new Date(this.originalTime)) + ")->to(" + this.df.format(new Date(this.finalTime)) + ")]\uff1a" + DebugUtils.formatConsumeTime(consumTime) + "\u3010" + consumTime + "\u3011\uff0c\u4efb\u52a1\u6267\u884c\u603b\u8017\u65f6\uff1a" + DebugUtils.formatConsumeTime(this.sumCount) + "\u3010" + this.sumCount + "\u3011\uff01";
        }

        public String toString() {
            switch (this.mode) {
                case 1: {
                    this.updateCount();
                    return this.fromCurrentPoint();
                }
                case 2: {
                    return this.fromEndPoint();
                }
            }
            return null;
        }

        private void updateCount() {
            if (this.mode != 2) {
                ++this.seq;
                this.sumCount += this.currentEndTime - this.currentStartTime;
            }
        }
    }
}

