/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EnumUtils {
    public static <E extends Enum<E>> E getEnum(Class<?> enumClass, String enumName) {
        return EnumUtils.getEnum(enumClass, enumName, null);
    }

    public static <E extends Enum<E>> E getEnum(Class<?> enumClass, String enumName, E defaultEnum) {
        return EnumUtils.getEnum(enumClass, enumName, defaultEnum, false);
    }

    public static <E extends Enum<E>> E getEnum(Class<?> enumClass, String enumName, E defaultEnum, boolean ignoreCase) {
        if (enumName == null || !enumClass.isEnum()) {
            return defaultEnum;
        }
        for (Object each : enumClass.getEnumConstants()) {
            String eachEnumName = ((Enum)each).name();
            if (!(ignoreCase ? eachEnumName.equalsIgnoreCase(enumName) : eachEnumName.equals(enumName))) continue;
            return (E)((Enum)each);
        }
        return defaultEnum;
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<?> enumClass, String enumName) {
        return EnumUtils.getEnumIgnoreCase(enumClass, enumName, null);
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<?> enumClass, String enumName, E defaultEnum) {
        return EnumUtils.getEnum(enumClass, enumName, defaultEnum, true);
    }

    public static <E> List<E> getEnumList(Class<E> enumClass) {
        if (enumClass == null || !enumClass.isEnum()) {
            return Collections.emptyList();
        }
        return new ArrayList<E>(Arrays.asList(enumClass.getEnumConstants()));
    }

    public static <E> Map<String, E> getEnumMap(Class<E> enumClass) {
        if (enumClass == null || !enumClass.isEnum()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, E> map = new LinkedHashMap<String, E>();
        for (E e : enumClass.getEnumConstants()) {
            map.put(((Enum)e).name(), e);
        }
        return map;
    }
}

