/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.IoUtils;
import com.github.kancyframework.springx.utils.PathUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class FileUtils {
    public static String readClasspathFileToString(String classpath, Charset encoding) throws IOException {
        return new String(FileUtils.readClasspathFileToByteArray(classpath), encoding);
    }

    public static String readClasspathFileToString(String classpath) throws IOException {
        return FileUtils.readClasspathFileToString(classpath, Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset encoding) throws IOException {
        return new String(FileUtils.readFileToByteArray(file), encoding);
    }

    public static String readFileToString(File file) throws IOException {
        return new String(FileUtils.readFileToByteArray(file), Charset.defaultCharset());
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtils.copy(in, out);
        return out.toByteArray();
    }

    public static byte[] readClasspathFileToByteArray(String classpath) throws IOException {
        InputStream in = FileUtils.class.getResourceAsStream(FileUtils.getClasspath(classpath));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtils.copy(in, out);
        return out.toByteArray();
    }

    public static void appendToFile(String str, File file) throws IOException {
        FileUtils.writeByteArrayToFile(str.getBytes(), file, true);
    }

    public static void appendToFile(byte[] bytes, File file) throws IOException {
        FileUtils.writeByteArrayToFile(bytes, file, true);
    }

    public static void appendLineToFile(String line, File file) throws IOException {
        FileUtils.writeByteArrayToFile((line + System.lineSeparator()).getBytes(), file, true);
    }

    public static void writeToFile(String str, File file) throws IOException {
        FileUtils.writeByteArrayToFile(str.getBytes(), file, true);
    }

    public static void writeToFile(String str, File file, boolean append) throws IOException {
        FileUtils.writeByteArrayToFile(str.getBytes(), file, append);
    }

    public static void writeLines(List<String> lines, File file, boolean append) throws IOException {
        if (Objects.isNull(lines) || lines.isEmpty()) {
            return;
        }
        String str = lines.stream().collect(Collectors.joining(System.lineSeparator()));
        if (append) {
            str = str + System.lineSeparator();
        }
        FileUtils.writeByteArrayToFile(str.getBytes(), file, append);
    }

    public static void writeByteArrayToFile(byte[] bytes, File file) throws IOException {
        FileUtils.writeByteArrayToFile(bytes, file, false);
    }

    public static void writeByteArrayToFile(byte[] bytes, File file, boolean append) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        FileOutputStream out = new FileOutputStream(file, append);
        IoUtils.copy(in, out);
    }

    public static List<String> readLines(File file) throws IOException {
        return FileUtils.readLines(file, Charset.defaultCharset().displayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file, String encoding) throws IOException {
        List<String> list;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            list = IoUtils.readLines((InputStream)fileInputStream, encoding);
        }
        catch (Throwable throwable) {
            IoUtils.closeResource(fileInputStream);
            throw throwable;
        }
        IoUtils.closeResource(fileInputStream);
        return list;
    }

    public static List<String> readClasspathFileLines(String classpath) throws IOException {
        return FileUtils.readClasspathFileLines(classpath, Charset.defaultCharset().displayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readClasspathFileLines(String classpath, String encoding) throws IOException {
        List<String> list;
        InputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.class.getResourceAsStream(FileUtils.getClasspath(classpath));
            list = IoUtils.readLines(fileInputStream, encoding);
        }
        catch (Throwable throwable) {
            IoUtils.closeResource(fileInputStream);
            throw throwable;
        }
        IoUtils.closeResource(fileInputStream);
        return list;
    }

    public static void writeObject(File file, Serializable object) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(object);
        }
        catch (Throwable throwable) {
            IoUtils.closeResource(objectOutputStream);
            throw throwable;
        }
        IoUtils.closeResource(objectOutputStream);
    }

    public static <T extends Serializable> T readObject(File file) throws IOException, ClassNotFoundException {
        Serializable serializable;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            serializable = (Serializable)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            IoUtils.closeResource(objectInputStream);
            throw throwable;
        }
        IoUtils.closeResource(objectInputStream);
        return (T)serializable;
    }

    public static boolean existsFile(String filePath) {
        File file = new File(PathUtils.getFileAbsolutePath(filePath));
        return Objects.nonNull(file) && file.isFile() && file.exists();
    }

    public static boolean existsClassPathFile(String filePath) {
        if (StringUtils.isBlank(filePath)) {
            return false;
        }
        String resourcePath = FileUtils.getClasspath(filePath);
        URL resource = FileUtils.class.getResource(resourcePath);
        return Objects.nonNull(resource);
    }

    public static boolean existsFile(File file) {
        return Objects.nonNull(file) && file.isFile() && file.exists();
    }

    public static boolean existsDirectory(File file) {
        return Objects.nonNull(file) && file.isDirectory() && file.exists();
    }

    public static File createNewFile(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            if (Objects.nonNull(file.getParentFile())) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    public static File createNewDirectory(String filePath) {
        File file = new File(filePath);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    public static void deleteFile(File dataFile) {
        boolean delete;
        if (Objects.nonNull(dataFile) && !(delete = dataFile.delete())) {
            dataFile.deleteOnExit();
        }
    }

    private static String getClasspath(String filePath) {
        filePath = filePath.trim();
        String resourcePath = null;
        resourcePath = filePath.startsWith("classpath:/") ? filePath.substring(10) : (filePath.startsWith("classpath:") ? "/".concat(filePath.substring(10)) : filePath);
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/".concat(resourcePath);
        }
        return resourcePath;
    }

    public static List<String> listFiles(String fileDir, boolean isContainSubDir) {
        return FileUtils.listFiles(fileDir, isContainSubDir, File::isFile);
    }

    public static List<String> listFiles(String fileDir, boolean isContainSubDir, Function<File, Boolean> fileFilter) {
        ArrayList<String> filePaths = new ArrayList<String>();
        File file = new File(fileDir);
        if (file.isDirectory()) {
            File[] files;
            if (fileFilter.apply(file).booleanValue()) {
                filePaths.add(file.getAbsolutePath());
            }
            if ((files = file.listFiles()) != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        if (!isContainSubDir) continue;
                        List<String> subFilePaths = FileUtils.listFiles(f.getAbsolutePath(), true, fileFilter);
                        filePaths.addAll(subFilePaths);
                        continue;
                    }
                    if (!fileFilter.apply(f).booleanValue()) continue;
                    filePaths.add(f.getAbsolutePath());
                }
            }
        } else if (fileFilter.apply(file).booleanValue()) {
            filePaths.add(file.getAbsolutePath());
        }
        return filePaths;
    }
}

