/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.log.Log;
import com.github.kancyframework.springx.utils.PropertiesUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FreemarkerUtils {
    private static String baseTemplatePath = "/ftl";
    private static Map<Class, Configuration> configurations = new HashMap<Class, Configuration>();

    public static Optional<String> render(String templatePath, Map<String, Object> templateData) {
        return FreemarkerUtils.render(templatePath, templateData, Configuration.class);
    }

    public static Optional<String> render(String templatePath, Map<String, Object> templateData, Class clazz) {
        StringWriter result = null;
        try {
            Template template = FreemarkerUtils.getConfiguration(clazz).getTemplate(templatePath);
            result = new StringWriter();
            template.process(templateData, (Writer)result);
        }
        catch (IOException e) {
            throw new RuntimeException("\u6a21\u677f\u5f15\u64ce\u6267\u884c\u9519\u8bef\uff01", e);
        }
        catch (TemplateException e) {
            throw new RuntimeException("Freemarker\u6a21\u677f\u53ef\u80fd\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", e);
        }
        return Optional.ofNullable(result.getBuffer().toString());
    }

    public static Optional<String> execute(String templateData, Map<String, Object> modelData) {
        return FreemarkerUtils.execute(templateData, modelData, Configuration.class);
    }

    public static Optional<String> execute(String templateData, Map<String, Object> modelData, Class clazz) {
        StringWriter result = null;
        try {
            Template template = new Template(null, templateData, FreemarkerUtils.getConfiguration(clazz));
            result = new StringWriter();
            template.process(modelData, (Writer)result);
        }
        catch (IOException e) {
            throw new RuntimeException("\u6a21\u677f\u5f15\u64ce\u6267\u884c\u9519\u8bef\uff01", e);
        }
        catch (TemplateException e) {
            throw new RuntimeException("Freemarker\u6a21\u677f\u53ef\u80fd\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", e);
        }
        return Optional.ofNullable(result.getBuffer().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration getConfiguration(Class clazz) {
        Configuration configuration = configurations.get(clazz);
        if (Objects.isNull(configuration)) {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                if (Objects.isNull(configuration)) {
                    configuration = FreemarkerUtils.initConfiguration(clazz);
                    configurations.put(clazz, configuration);
                }
            }
        }
        return configuration;
    }

    private static Configuration initConfiguration(Class clazz) {
        Configuration configuration = new Configuration();
        configuration.setClassForTemplateLoading(clazz, baseTemplatePath);
        FreemarkerUtils.setDefaultConfiguration(configuration);
        ArrayList<String> confList = new ArrayList<String>();
        confList.add("/META-INF/freemarker.properties");
        confList.add("freemarker.properties");
        confList.add("/ftl/freemarker.properties");
        confList.forEach(p -> {
            try {
                configuration.setSettings(PropertiesUtils.loadClasspathProperties(p, clazz.getClassLoader()));
                Log.info((String)"load freemarker config file : {}", (Object[])new Object[]{p});
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return configuration;
    }

    private static Configuration setDefaultConfiguration(Configuration configuration) {
        configuration.setLocale(Locale.CHINA);
        configuration.setDateFormat("yyyy-MM-dd");
        configuration.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
        configuration.setNumberFormat("#.######");
        configuration.setBooleanFormat("true,false");
        return configuration;
    }
}

