/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.function.SerializableFunction;
import com.github.kancyframework.springx.utils.PropertyNamer;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;

public class FunctionUtils {
    private static final Map<String, Field> fieldCache = new HashMap<String, Field>();

    public static <T> String getPropertyName(SerializableFunction<T> function) {
        try {
            SerializedLambda lambda = FunctionUtils.getSerializedLambda(function);
            if (lambda == null) {
                return null;
            }
            String methodName = lambda.getImplMethodName();
            return PropertyNamer.methodToProperty(methodName);
        }
        catch (Exception var3) {
            return null;
        }
    }

    public static <T> String getColumnName(SerializableFunction<T> function) {
        try {
            SerializedLambda serializedLambda = FunctionUtils.getSerializedLambda(function);
            if (serializedLambda == null) {
                return null;
            }
            String methodName = serializedLambda.getImplMethodName();
            String propertyName = PropertyNamer.methodToProperty(methodName);
            String className = serializedLambda.getImplClass().replace("/", ".");
            Field field = FunctionUtils.findFieldFromCache(className, propertyName);
            return FunctionUtils.getColumnName(field);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field findFieldFromCache(String className, String propertyName) throws ClassNotFoundException {
        String cacheKey = String.format("%s:%s", className, propertyName);
        if (!fieldCache.containsKey(cacheKey)) {
            Map<String, Field> map = fieldCache;
            synchronized (map) {
                if (!fieldCache.containsKey(cacheKey)) {
                    Class<?> aClass = Class.forName(className);
                    Field field = FunctionUtils.getField(aClass, propertyName);
                    if (Objects.isNull(field)) {
                        field = FunctionUtils.getField(aClass, String.format("is%s", FunctionUtils.firstUpper(propertyName)));
                    }
                    fieldCache.put(cacheKey, field);
                }
            }
        }
        return fieldCache.get(cacheKey);
    }

    private static Field getField(Class<?> aClass, String fieldName) {
        try {
            return aClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                return aClass.getField(fieldName);
            }
            catch (NoSuchFieldException e2) {
                return null;
            }
        }
    }

    private static <T> SerializedLambda getSerializedLambda(SerializableFunction<T> function) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        method.setAccessible(true);
        Object obj = method.invoke(function, new Object[0]);
        if (!(obj instanceof SerializedLambda)) {
            return null;
        }
        SerializedLambda lambda = (SerializedLambda)obj;
        return lambda;
    }

    private static String getColumnName(Field field) {
        Column column = field.getAnnotation(Column.class);
        String fieldName = field.getName();
        if (Objects.isNull(column)) {
            return FunctionUtils.wrapColumnName(FunctionUtils.camelCaseToUnderscore(fieldName));
        }
        return FunctionUtils.wrapColumnName(column.name());
    }

    private static String wrapColumnName(String columnName) {
        return "`".concat(columnName).concat("`");
    }

    private static String camelCaseToUnderscore(String camelCase) {
        StringBuilder builder = new StringBuilder(camelCase.replace('.', '_'));
        for (int i = 1; i < builder.length() - 1; ++i) {
            if (!FunctionUtils.isUnderscoreRequired(builder.charAt(i - 1), builder.charAt(i), builder.charAt(i + 1))) continue;
            builder.insert(i++, '_');
        }
        return builder.toString().toLowerCase();
    }

    private static boolean isUnderscoreRequired(char before, char current, char after) {
        return Character.isLowerCase(before) && Character.isUpperCase(current) && Character.isLowerCase(after);
    }

    private static String firstUpper(String str) {
        if (Objects.isNull(str) || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

