/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.FileUtils;
import com.github.kancyframework.springx.utils.JdkHttpUtils;
import com.github.kancyframework.springx.utils.PathUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Calendar;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IDCardUtils {
    private static final String[] zoneNum = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static final String[] PARITYBIT = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
    private static String[] districtList;
    private static int currYear;
    private static int minAge;
    private static int maxAge;
    private static Properties p;

    public static void main(String[] args) {
        System.out.println(IDCardUtils.create());
    }

    public static String create() {
        String district = IDCardUtils.getdistrictcode();
        String birthday = IDCardUtils.getBirthday();
        String randomNumber = IDCardUtils.getRandomNumber();
        String checkCode = IDCardUtils.getCheckCode(district + birthday + randomNumber);
        return district + birthday + randomNumber + checkCode;
    }

    public static String create(String district) {
        return IDCardUtils.create(district, IDCardUtils.getBirthday(), IDCardUtils.getRandomNumber());
    }

    public static String create(String district, String birthday) {
        return IDCardUtils.create(district, birthday, IDCardUtils.getRandomNumber());
    }

    public static String create(String district, String birthday, String randomNumber) {
        if (district.length() != 6 || birthday.length() != 8 || randomNumber.length() != 3 || !IDCardUtils.executeRegMatcher("^([1-9]\\d{0,}|0)$", district + birthday + randomNumber)) {
            return null;
        }
        return district + birthday + randomNumber + IDCardUtils.getCheckCode(String.valueOf(district) + birthday + randomNumber);
    }

    public static boolean isPersonId(String personId) {
        if (personId.length() != 15 && personId.length() != 18 || !IDCardUtils.executeRegMatcher("^([1-9]\\d{0,})$", personId.substring(0, personId.length() - 1))) {
            return false;
        }
        String num = personId.substring(0, 2);
        for (int i = 0; i < zoneNum.length && !zoneNum[i].equals(num); ++i) {
            if (i != zoneNum.length - 1) continue;
            return false;
        }
        String year = personId.length() == 15 ? "19" + personId.substring(6, 8) : personId.substring(6, 10);
        int iyear = Integer.parseInt(year);
        if (iyear < 1900 || iyear > currYear) {
            return false;
        }
        String month = personId.length() == 15 ? personId.substring(8, 10) : personId.substring(10, 12);
        int imonth = Integer.parseInt(month);
        if (imonth < 1 || imonth > 12) {
            return false;
        }
        String day = personId.length() == 15 ? personId.substring(10, 12) : personId.substring(12, 14);
        int iday = Integer.parseInt(day);
        if (iday < 1 || iday > 31) {
            return false;
        }
        if (personId.length() == 18) {
            return IDCardUtils.getCheckCode(personId.substring(0, 17)).equals(personId.substring(17));
        }
        return true;
    }

    public static void setAgeRange(int minAge, int maxAge) {
        IDCardUtils.minAge = minAge;
        IDCardUtils.maxAge = maxAge;
    }

    private static String getCheckCode(String certid) {
        int sum = 0;
        for (int i = 0; i < certid.length(); ++i) {
            sum += POWER[i] * (certid.charAt(i) - 48);
        }
        return PARITYBIT[sum % 11];
    }

    private static String getRandomNumber() {
        return IDCardUtils.zfill(String.valueOf(new Random().nextInt(999) + 1), 3);
    }

    public static String getBirthday() {
        Random random = new Random();
        String year = String.valueOf(currYear - random.nextInt(maxAge - minAge) - minAge);
        int iMonth = random.nextInt(12) + 1;
        String month = IDCardUtils.zfill(String.valueOf(iMonth), 2);
        String day = null;
        day = iMonth == 2 ? String.valueOf(random.nextInt(28) + 1) : (iMonth == 4 || iMonth == 6 || iMonth == 9 || iMonth == 11 ? String.valueOf(random.nextInt(30) + 1) : String.valueOf(random.nextInt(31) + 1));
        day = IDCardUtils.zfill(day, 2);
        return year + month + day;
    }

    public static String getdistrictcode() {
        String districtCode = districtList[new Random().nextInt(districtList.length)].trim();
        while ("".equals(districtCode) || districtCode == null) {
            districtCode = districtList[new Random().nextInt(districtList.length)].trim();
        }
        return districtCode;
    }

    private static String zfill(String obj, int size) {
        for (int i = obj.length(); i < size; ++i) {
            obj = "0" + obj;
        }
        return obj;
    }

    private static boolean executeRegMatcher(String reg, String param) {
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(param);
        return m.find();
    }

    public static String parseAddress(String cid) {
        String address = "\u672a\u77e5";
        try {
            String addressCode = String.format("%s%s", cid.substring(0, 2), "0000");
            if (p.containsKey(addressCode)) {
                address = p.get(addressCode).toString();
                addressCode = String.format("%s%s", cid.substring(0, 4), "00");
                if (p.containsKey(addressCode)) {
                    address = address + p.get(addressCode).toString();
                    addressCode = cid.substring(0, 6);
                    if (p.containsKey(addressCode) && !String.format("%s%s", cid.substring(0, 4), "00").equals(addressCode)) {
                        address = address + p.get(addressCode).toString();
                    }
                }
            }
            return address;
        }
        catch (Exception e) {
            System.err.println("\u8eab\u4efd\u8bc1\u5730\u5740\u7801\u4fe1\u606f\u6709\u8bef\uff1a" + e);
            return address;
        }
    }

    static {
        currYear = 1994;
        minAge = 18;
        maxAge = 60;
        p = new Properties();
        try {
            currYear = Calendar.getInstance().get(1);
            File file = new File(PathUtils.userHome("district.dat"));
            if (FileUtils.existsFile(file)) {
                p.load(Files.newInputStream(file.toPath(), new OpenOption[0]));
            } else {
                String district = RemoteDistrictMetaData.getDistrict();
                if (StringUtils.isNotBlank(district)) {
                    p.load(new ByteArrayInputStream(district.getBytes()));
                    FileUtils.writeToFile(district, file);
                    System.out.println("write district to " + file.getAbsolutePath());
                }
            }
            districtList = p.keySet().toArray(new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class RemoteDistrictMetaData {
        private static String district;

        private RemoteDistrictMetaData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static String getDistrict() {
            if (!Objects.isNull(district)) return district;
            Class<RemoteDistrictMetaData> clazz = RemoteDistrictMetaData.class;
            synchronized (RemoteDistrictMetaData.class) {
                if (!Objects.isNull(district)) return district;
                try {
                    district = JdkHttpUtils.getForm("https://files.cnblogs.com/files/kancy/district.json");
                }
                catch (IOException e) {
                    district = "";
                }
                return district;
            }
        }
    }
}

