/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.NumberUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

public class IDUtils {
    private static SnowflakeIdWorker idWorker = new SnowflakeIdWorker();

    private IDUtils() {
    }

    public static String getUUIDString() {
        return UUID.randomUUID().toString();
    }

    public static String get32UUIDString() {
        return IDUtils.getUUIDString().replace("-", "");
    }

    public static long getSnowflakeId() {
        return idWorker.getSerialNo();
    }

    public static String getSnowflakeNo(String prefix) {
        return idWorker.getSerialNo(prefix);
    }

    public static String getDateSnowflakeNo(String prefix) {
        return idWorker.getDateSerialNo(prefix);
    }

    public static String getDateSnowflakeNo() {
        return idWorker.getDateSerialNo();
    }

    private static class SnowflakeIdWorker {
        private final long twepoch = 1514736000000L;
        private final long workerIdBits = 5L;
        private final long datacenterIdBits = 5L;
        private final long maxWorkerId = 31L;
        private final long maxDatacenterId = 31L;
        private final long sequenceBits = 12L;
        private final long workerIdShift = 12L;
        private final long datacenterIdShift = 17L;
        private final long timestampLeftShift = 22L;
        private final long sequenceMask = 4095L;
        private long workerId;
        private long datacenterId;
        private long sequence = 0L;
        private long lastTimestamp = -1L;
        private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");
        private static Integer pid = SnowflakeIdWorker.getPId();

        public SnowflakeIdWorker() {
            long workerId = this.getWorkId();
            long datacenterId = this.getDataCenterId();
            this.init(workerId, datacenterId);
        }

        public SnowflakeIdWorker(long workerId, long datacenterId) {
            this.init(workerId, datacenterId);
        }

        private void init(long workerId, long datacenterId) {
            if (workerId > 31L || workerId < 0L) {
                throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
            }
            if (datacenterId > 31L || datacenterId < 0L) {
                throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
            }
            this.workerId = workerId;
            this.datacenterId = datacenterId;
        }

        public synchronized long getSerialNo() {
            return this.nextId();
        }

        public synchronized String getSerialNo(String prefix) {
            return prefix + this.nextId();
        }

        public synchronized String getDateSerialNo() {
            return dateFormatter.format(new Date()) + pid + this.nextId();
        }

        public synchronized String get62SerialNo() {
            return NumberUtils.to62Str(this.nextId());
        }

        private long nextId() {
            long timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = this.tilNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return timestamp - 1514736000000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
        }

        public synchronized String getDateSerialNo(String prefix) {
            if (prefix.length() >= 6) {
                throw new IllegalArgumentException("prefix length is [0,5].");
            }
            int pidLen = 6 - prefix.length();
            String range = "";
            for (int i = pidLen; i > 0; --i) {
                range = range + "9";
            }
            return prefix + dateFormatter.format(new Date()) + String.format("%0" + pidLen + "d", pid % Integer.parseInt(range)) + this.nextId();
        }

        protected long tilNextMillis(long lastTimestamp) {
            long timestamp = this.timeGen();
            while (timestamp <= lastTimestamp) {
                timestamp = this.timeGen();
            }
            return timestamp;
        }

        protected long timeGen() {
            return System.currentTimeMillis();
        }

        private long numRandom(long bound) {
            Random random = new Random();
            int anInt = random.nextInt((int)bound);
            return anInt;
        }

        private Long getWorkId() {
            try {
                String hostAddress = Inet4Address.getLocalHost().getHostAddress();
                int[] ints = SnowflakeIdWorker.toCodePoints(hostAddress);
                int sums = 0;
                for (int b : ints) {
                    sums += b;
                }
                return sums % 32;
            }
            catch (UnknownHostException e) {
                return this.numRandom(31L);
            }
        }

        private Long getDataCenterId() {
            try {
                int[] ints = SnowflakeIdWorker.toCodePoints(Inet4Address.getLocalHost().getHostName());
                int sums = 0;
                for (int i : ints) {
                    sums += i;
                }
                return sums % 32;
            }
            catch (UnknownHostException e) {
                return this.numRandom(31L);
            }
        }

        private static int[] toCodePoints(CharSequence str) {
            if (str == null) {
                return null;
            }
            if (str.length() == 0) {
                return new int[0];
            }
            String s = str.toString();
            int[] result = new int[s.codePointCount(0, s.length())];
            int index = 0;
            for (int i = 0; i < result.length; ++i) {
                result[i] = s.codePointAt(index);
                index += Character.charCount(result[i]);
            }
            return result;
        }

        private static Integer getPId() {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            String jvmName = bean.getName();
            String pid = jvmName.split("@")[0];
            return Integer.parseInt(pid);
        }
    }
}

