/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class IoUtils {
    public static List<String> readLines(InputStream input, String encoding) throws IOException {
        return IoUtils.readLines(input, Charset.forName(encoding));
    }

    public static List<String> readLines(InputStream input, Charset encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return IoUtils.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return new String(IoUtils.toByteArray(input), encoding);
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtils.copy(input, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            byte[] buf = new byte[1024];
            int read = 0;
            while ((read = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, read);
            }
        }
        finally {
            IoUtils.closeResource(inputStream);
            IoUtils.closeResource(outputStream);
        }
    }

    public static void closeResource(Object object) throws IOException {
        if (Objects.nonNull(object)) {
            if (InputStream.class.isInstance(object)) {
                ((InputStream)object).close();
            } else if (OutputStream.class.isInstance(object)) {
                ((OutputStream)object).close();
            } else if (Writer.class.isInstance(object)) {
                ((Writer)object).close();
            } else if (Reader.class.isInstance(object)) {
                ((Reader)object).close();
            }
        }
    }
}

