/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.log.Logger;
import com.github.kancyframework.springx.log.LoggerFactory;
import com.github.kancyframework.springx.utils.DateUtils;
import com.github.kancyframework.springx.utils.FileUtils;
import com.github.kancyframework.springx.utils.IoUtils;
import com.github.kancyframework.springx.utils.PathUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JdkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(JdkHttpUtils.class);
    private static final String CHARSET_UTF_8 = "utf-8";
    private static final String C_TYPE_FORM_FORMAT = "application/x-www-form-urlencoded;charset=%s";
    private static final String C_TYPE_JSON_FORMAT = "application/json; charset=%s";
    private static final String C_TYPE_STREAM_FORMAT = "application/octet-stream";
    private static final ThreadLocal<Integer> CONNECT_TIMEOUT = ThreadLocal.withInitial(() -> 5000);
    private static final ThreadLocal<Integer> READ_TIMEOUT = ThreadLocal.withInitial(() -> 10000);
    private static final ThreadLocal<String> CHARSET = ThreadLocal.withInitial(() -> "utf-8");

    public static void downloadFile(String httpUrl, String filePath) throws IOException {
        JdkHttpUtils.downloadFile(httpUrl, new File(filePath));
    }

    public static void download(String httpUrl, String fileName) throws IOException {
        JdkHttpUtils.download(httpUrl, fileName, false);
    }

    public static void download(String httpUrl, String fileName, boolean uniq) throws IOException {
        int lastIndexOf;
        if (uniq && (lastIndexOf = fileName.lastIndexOf(".")) > 0 && lastIndexOf < fileName.length()) {
            fileName = String.format("%s_%s%s", fileName.substring(0, lastIndexOf), DateUtils.getNowTimestampStr(), fileName.substring(lastIndexOf));
        }
        JdkHttpUtils.downloadFile(httpUrl, new File(PathUtils.path(System.getProperty("user.home"), "Downloads", fileName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String httpUrl, File file) throws IOException {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            long startTime = System.currentTimeMillis();
            URL url = new URL(httpUrl);
            HttpURLConnection connection = JdkHttpUtils.getHttpURLConnection(url);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", C_TYPE_STREAM_FORMAT);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Connection", "Keep-Alive");
            bis = new BufferedInputStream(connection.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(FileUtils.createNewFile(file.getAbsolutePath())));
            int size = 0;
            int len = 0;
            byte[] buff = new byte[524288];
            while ((len = bis.read(buff)) != -1) {
                bos.write(buff, 0, len);
                bos.flush();
                size += len;
            }
            log.info("\u6210\u529f\u4e0b\u8f7d\u6587\u4ef6\uff1a{} , \u603b\u5927\u5c0f\uff1a{}k ({}) , \u8017\u65f6\uff1a{} ms", new Object[]{PathUtils.format(file), size / 1024, size, System.currentTimeMillis() - startTime});
        }
        catch (Throwable throwable) {
            IoUtils.closeResource(bis);
            IoUtils.closeResource(bos);
            throw throwable;
        }
        IoUtils.closeResource(bis);
        IoUtils.closeResource(bos);
    }

    private static HttpURLConnection getHttpURLConnection(URL url) throws IOException {
        HttpURLConnection connection;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier((hostname, session) -> true);
            connection = connHttps;
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        return connection;
    }

    public static InputStream download(String httpUrl) throws IOException {
        URL url = new URL(httpUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", C_TYPE_STREAM_FORMAT);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.connect();
        int contentLength = connection.getContentLength();
        if (contentLength > 32) {
            return new BufferedInputStream(connection.getInputStream());
        }
        return connection.getInputStream();
    }

    public static String putJson(String url, String jsonContent, Map<String, ?> headerMap) throws IOException {
        return JdkHttpUtils.put(url, jsonContent, CONNECT_TIMEOUT.get(), READ_TIMEOUT.get(), String.format(C_TYPE_JSON_FORMAT, CHARSET.get()), headerMap);
    }

    public static String putJson(String url, String jsonContent) throws IOException {
        return JdkHttpUtils.putJson(url, jsonContent, null);
    }

    public static String putForm(String url) throws IOException {
        return JdkHttpUtils.putForm(url, null);
    }

    public static String putForm(String url, Map<String, Object> params) throws IOException {
        return JdkHttpUtils.putForm(url, params, null);
    }

    public static String putForm(String url, Map<String, Object> params, Map<String, ?> header) throws IOException {
        return JdkHttpUtils.put(url, JdkHttpUtils.buildQuery(params), CONNECT_TIMEOUT.get(), READ_TIMEOUT.get(), String.format(C_TYPE_FORM_FORMAT, CHARSET.get()), header);
    }

    public static String postJson(String url, String jsonContent, Map<String, String> headerMap) throws IOException {
        return JdkHttpUtils.post(url, jsonContent, CONNECT_TIMEOUT.get(), READ_TIMEOUT.get(), String.format(C_TYPE_JSON_FORMAT, CHARSET.get()), headerMap);
    }

    public static String postJson(String url, String jsonContent) throws IOException {
        return JdkHttpUtils.postJson(url, jsonContent, null);
    }

    public static String postForm(String url) throws IOException {
        return JdkHttpUtils.postForm(url, null);
    }

    public static String postForm(String url, Map<String, Object> params) throws IOException {
        return JdkHttpUtils.postForm(url, params, null);
    }

    public static String postForm(String url, Map<String, Object> params, Map<String, ?> header) throws IOException {
        return JdkHttpUtils.doRequest("POST", url, JdkHttpUtils.buildQuery(params), CONNECT_TIMEOUT.get(), READ_TIMEOUT.get(), String.format(C_TYPE_FORM_FORMAT, CHARSET.get()), header);
    }

    public static String getForm(String url) throws IOException {
        return JdkHttpUtils.getForm(url, null);
    }

    public static String getForm(String url, Map<String, Object> params) throws IOException {
        return JdkHttpUtils.getForm(url, params, null);
    }

    public static String getForm(String url, Map<String, Object> params, Map<String, ?> header) throws IOException {
        return JdkHttpUtils.get(url, JdkHttpUtils.buildQuery(params), CONNECT_TIMEOUT.get(), READ_TIMEOUT.get(), String.format(C_TYPE_FORM_FORMAT, CHARSET.get()), header);
    }

    public static String get(String url) throws IOException {
        return JdkHttpUtils.doRequest("GET", url, null, 0, 0, null, null);
    }

    public static String get(String url, String contentType) throws IOException {
        return JdkHttpUtils.doRequest("GET", url, null, 0, 0, contentType, null);
    }

    public static String get(String url, Map<String, ?> headerMap) throws IOException {
        return JdkHttpUtils.doRequest("GET", url, null, 0, 0, null, headerMap);
    }

    public static String get(String url, String requestContent, int connectTimeout, int readTimeout, String contentType, Map<String, ?> headerMap) throws IOException {
        return JdkHttpUtils.doRequest("GET", url, requestContent, connectTimeout, readTimeout, contentType, headerMap);
    }

    public static String post(String url, String requestContent, int connectTimeout, int readTimeout, String contentType, Map<String, ?> headerMap) throws IOException {
        return JdkHttpUtils.doRequest("POST", url, requestContent, connectTimeout, readTimeout, contentType, headerMap);
    }

    public static String put(String url, String requestContent, int connectTimeout, int readTimeout, String contentType, Map<String, ?> headerMap) throws IOException {
        return JdkHttpUtils.doRequest("PUT", url, requestContent, connectTimeout, readTimeout, contentType, headerMap);
    }

    public static String delete(String url, String requestContent, int connectTimeout, int readTimeout, String contentType, Map<String, ?> headerMap) throws IOException {
        return JdkHttpUtils.doRequest("DELETE", url, requestContent, connectTimeout, readTimeout, contentType, headerMap);
    }

    public static String doRequest(String method, String url, String requestContent, String contentType, Map<String, ?> headerMap) throws IOException {
        return JdkHttpUtils.doRequest(method, url, requestContent, CONNECT_TIMEOUT.get(), READ_TIMEOUT.get(), contentType, headerMap);
    }

    public static String doRequest(String method, String url, String requestContent, Map<String, ?> headerMap) throws IOException {
        return JdkHttpUtils.doRequest(method, url, requestContent, CONNECT_TIMEOUT.get(), READ_TIMEOUT.get(), null, headerMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doRequest(String method, String url, String requestContent, int connectTimeout, int readTimeout, String contentType, Map<String, ?> headerMap) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = JdkHttpUtils.getConnection(new URL(url), method, contentType, headerMap);
            if (connectTimeout > 0) {
                conn.setConnectTimeout(connectTimeout);
            }
            if (readTimeout > 0) {
                conn.setReadTimeout(readTimeout);
            }
            if (requestContent != null && requestContent.trim().length() > 0) {
                out = conn.getOutputStream();
                out.write(requestContent.getBytes(CHARSET_UTF_8));
            }
            rsp = JdkHttpUtils.getResponseAsString(conn);
        }
        finally {
            JdkHttpUtils.removeThreadLocal();
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static void setCurrentConnectTimeout(int connectTimeout) {
        CONNECT_TIMEOUT.set(connectTimeout);
    }

    public static void setCurrentReadTimeout(int readTimeout) {
        READ_TIMEOUT.set(readTimeout);
    }

    public static void setCurrentCharsetName(String charsetName) {
        CHARSET.set(charsetName);
    }

    private static void removeThreadLocal() {
        CONNECT_TIMEOUT.remove();
        READ_TIMEOUT.remove();
        CHARSET.remove();
    }

    private static HttpURLConnection getConnection(URL url, String method, String contentType, Map<String, ?> headerMap) throws IOException {
        HttpURLConnection conn = JdkHttpUtils.getHttpURLConnection(url);
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        if (StringUtils.isNotBlank(contentType)) {
            conn.setRequestProperty("Content-Type", contentType);
        }
        if (headerMap != null) {
            for (Map.Entry<String, ?> entry : headerMap.entrySet()) {
                if (!Objects.nonNull(entry.getValue())) continue;
                conn.setRequestProperty(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        return conn;
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        try {
            InputStream es = conn.getErrorStream();
            if (es == null) {
                return JdkHttpUtils.getStreamAsString(conn.getInputStream(), CHARSET_UTF_8, conn);
            }
            String msg = JdkHttpUtils.getStreamAsString(es, CHARSET_UTF_8, conn);
            if (msg != null && msg.trim().length() > 0) {
                throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
            }
            return msg;
        }
        catch (IOException e) {
            String streamAsString = JdkHttpUtils.getStreamAsString(conn.getErrorStream(), CHARSET_UTF_8, conn);
            if (!streamAsString.isEmpty()) {
                throw new IOException(String.format("%s\n%s", streamAsString, e.getMessage()), e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset, HttpURLConnection conn) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String buildQuery(Map<String, Object> params) throws IOException {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, Object> entry : entries) {
            String name = entry.getKey();
            if (!Objects.nonNull(entry.getValue())) continue;
            String value = String.valueOf(entry.getValue());
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, CHARSET_UTF_8));
        }
        return query.toString();
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }
}

