/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.FileUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Utils {
    public static String fileMd5(File file, boolean upperCase) throws IOException {
        String fileMd5 = Md5Utils.fileMd5(file);
        if (upperCase && StringUtils.isNotBlank(fileMd5)) {
            return fileMd5.toUpperCase();
        }
        return fileMd5;
    }

    public static String fileMd5(File file) throws IOException {
        return Md5Utils.md5(FileUtils.readFileToByteArray(file));
    }

    public static String md5(String buffer, boolean upperCase) {
        String md5 = Md5Utils.md5(buffer.getBytes());
        if (upperCase && StringUtils.isNotBlank(md5)) {
            return md5.toUpperCase();
        }
        return md5;
    }

    public static String md5(String buffer) {
        return Md5Utils.md5(buffer.getBytes());
    }

    public static String md5(byte[] bufferBytes) {
        String string = null;
        char[] hexDigist = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bufferBytes);
            byte[] datas = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte b = datas[i];
                str[k++] = hexDigist[b >>> 4 & 0xF];
                str[k++] = hexDigist[b & 0xF];
            }
            string = new String(str);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return string;
    }
}

