/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.context.EnumValue;
import com.github.kancyframework.springx.utils.ClassUtils;
import com.github.kancyframework.springx.utils.CollectionUtils;
import com.github.kancyframework.springx.utils.DateUtils;
import com.github.kancyframework.springx.utils.EnumUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ObjectUtils {
    public static boolean isEmpty(Object object) {
        if (Objects.isNull(object)) {
            return true;
        }
        if (object instanceof String) {
            return StringUtils.isEmpty((String)object);
        }
        if (object instanceof Collection) {
            return CollectionUtils.isEmpty((Collection)object);
        }
        if (object instanceof Map) {
            return CollectionUtils.isEmpty((Map)object);
        }
        if (object.getClass().isArray()) {
            return Objects.equals(Array.getLength(object), 0);
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectUtils.isEmpty(object);
    }

    public static boolean isBlank(Object object) {
        if (Objects.isNull(object)) {
            return true;
        }
        if (object instanceof String) {
            return StringUtils.isBlank((String)object);
        }
        return ObjectUtils.isEmpty(object);
    }

    public static boolean isNotBlank(Object object) {
        return !ObjectUtils.isBlank(object);
    }

    public static <T> T defaultNull(Object object, T def) {
        if (Objects.isNull(object)) {
            return def;
        }
        return (T)object;
    }

    public static <T> T defaultEmpty(Object object, T def) {
        if (ObjectUtils.isEmpty(object)) {
            return def;
        }
        return (T)object;
    }

    public static <T> T defaultBlank(Object object, T def) {
        if (ObjectUtils.isBlank(object)) {
            return def;
        }
        return (T)object;
    }

    public static <T> T cast(Object value, Class<T> type) {
        return ObjectUtils.cast(value, type, null);
    }

    public static <T> T cast(Object value, Class<T> type, T defaultValue) {
        Object returnValue;
        block28: {
            if (Objects.isNull(value)) {
                return defaultValue;
            }
            if (type.isInstance(value)) {
                return type.cast(value);
            }
            returnValue = null;
            String stringValue = String.valueOf(value);
            try {
                if (String.class.equals(type)) {
                    returnValue = stringValue;
                    break block28;
                }
                if (StringBuffer.class.equals(type)) {
                    returnValue = new StringBuffer(stringValue);
                    break block28;
                }
                if (StringBuilder.class.equals(type)) {
                    returnValue = new StringBuilder(stringValue);
                    break block28;
                }
                if (BigDecimal.class.equals(type)) {
                    returnValue = new BigDecimal(stringValue);
                    break block28;
                }
                if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
                    returnValue = Integer.parseInt(stringValue);
                    break block28;
                }
                if (Double.class.equals(type) || Double.TYPE.equals(type)) {
                    returnValue = Double.parseDouble(stringValue);
                    break block28;
                }
                if (Long.class.equals(type) || Long.TYPE.equals(type)) {
                    returnValue = Long.parseLong(stringValue);
                    break block28;
                }
                if (Float.class.equals(type) || Float.TYPE.equals(type)) {
                    returnValue = Float.valueOf(Float.parseFloat(stringValue));
                    break block28;
                }
                if (Short.class.equals(type) || Short.TYPE.equals(type)) {
                    returnValue = Short.parseShort(stringValue);
                    break block28;
                }
                if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
                    returnValue = Byte.parseByte(stringValue);
                    break block28;
                }
                if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                    returnValue = Boolean.parseBoolean(stringValue) || "1".equals(stringValue);
                    break block28;
                }
                if (Date.class.equals(type)) {
                    returnValue = DateUtils.toDateTime(stringValue);
                    break block28;
                }
                if (Duration.class.equals(type)) {
                    returnValue = Duration.parse(stringValue);
                    break block28;
                }
                if (LocalDate.class.equals(type)) {
                    try {
                        returnValue = LocalDate.parse(stringValue, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    }
                    catch (Exception e) {
                        returnValue = LocalDate.parse(stringValue, DateTimeFormatter.ofPattern("yyyy/MM/dd"));
                    }
                    break block28;
                }
                if (LocalDateTime.class.equals(type)) {
                    try {
                        returnValue = LocalDateTime.parse(stringValue, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (Exception e) {
                        returnValue = LocalDateTime.parse(stringValue, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss"));
                    }
                    break block28;
                }
                if (LocalTime.class.equals(type)) {
                    returnValue = LocalTime.parse(stringValue, DateTimeFormatter.ofPattern("HH:mm:ss"));
                    break block28;
                }
                if (ClassUtils.isEnum(type)) {
                    if (ClassUtils.isAssignableFrom(EnumValue.class, type)) {
                        List<T> enumList = EnumUtils.getEnumList(type);
                        for (T t : enumList) {
                            if (!ObjectUtils.equalsAny(stringValue, ((EnumValue)t).getCode(), ((Enum)t).name())) continue;
                            returnValue = t;
                            break block28;
                        }
                        break block28;
                    }
                    returnValue = EnumUtils.getEnumIgnoreCase(type, stringValue);
                    break block28;
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        if (Objects.isNull(returnValue)) {
            return defaultValue;
        }
        return (T)returnValue;
    }

    public static boolean equalsAny(Object obj, Object ... anyObjs) {
        for (Object anyObj : anyObjs) {
            if (!Objects.equals(obj, anyObj)) continue;
            return true;
        }
        return false;
    }
}

