/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.annotation.Order;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class OrderUtils {
    public static <T> List<T> sort(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            private int getPriority(Object o1) {
                Order order = o1.getClass().getAnnotation(Order.class);
                int priority = 0;
                if (Objects.nonNull(order)) {
                    priority = order.value();
                }
                return priority;
            }
        });
        return list;
    }
}

