/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.Md5Utils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class PasswordUtils {
    public static String password(String userName) {
        if (StringUtils.isEmpty(userName)) {
            return userName;
        }
        List<String> passwords = PasswordUtils.getPasswords(userName);
        return passwords.get(ThreadLocalRandom.current().nextInt(0, passwords.size()));
    }

    private static List<String> getPasswords(String userName) {
        String encrypt = Md5Utils.md5(String.format("%s%s%s%s", userName.length(), userName, userName, userName.length()));
        int skip = 4;
        int length = 6;
        HashSet<String> passwords = new HashSet<String>();
        char[] chars = encrypt.toCharArray();
        for (int i = 0; i < encrypt.length(); ++i) {
            StringBuilder sb = new StringBuilder();
            int pos = i;
            for (int j = 0; j < length && pos < encrypt.length(); pos += skip, ++j) {
                sb.append(chars[pos]);
            }
            if (pos >= encrypt.length()) break;
            passwords.add(sb.toString());
        }
        return Collections.unmodifiableList(new ArrayList(passwords));
    }

    public static boolean checkPassword(String userName, String password) {
        if (StringUtils.isEmpty(userName) || StringUtils.isEmpty(password)) {
            return false;
        }
        return PasswordUtils.getPasswords(userName).contains(password);
    }
}

