/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.StringUtils;
import com.github.kancyframework.springx.utils.SystemUtils;
import java.io.File;
import java.util.Objects;

public class PathUtils {
    public static String userHome(String ... paths) {
        return PathUtils.path(SystemUtils.getUserHome(), PathUtils.path(paths));
    }

    public static String path(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (!StringUtils.isNotBlank(path)) continue;
            sb.append(path).append("/");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return PathUtils.format(sb.toString());
    }

    public static String append(String path, String append) {
        return PathUtils.format(String.format("%s/%s", path, append));
    }

    public static String format(File file) {
        return PathUtils.format(file.getAbsolutePath());
    }

    public static String format(String filePath) {
        if (Objects.isNull(filePath)) {
            return filePath;
        }
        return filePath.replaceAll("\\\\+", "/").replaceAll("/+", "/");
    }

    public static String getFileAbsolutePath(String filePath) {
        String classPathPrefix = "classpath:";
        if (filePath.startsWith(classPathPrefix)) {
            String classPath = filePath.replace(classPathPrefix, "");
            if (!classPath.startsWith("/")) {
                classPath = "/" + classPath;
            }
            filePath = PathUtils.path(PathUtils.class.getResource("/").getFile(), classPath);
        }
        return PathUtils.format(new File(filePath).getAbsolutePath());
    }

    public static String classPath(String classpath) {
        return String.format("classpath:%s", classpath);
    }

    public static String getClassloaderClassPath(String classPath) {
        if (Objects.isNull(classPath)) {
            return classPath;
        }
        if (classPath.startsWith("classpath:")) {
            classPath = classPath.substring(10).trim();
        }
        if (StringUtils.startWithAny(classPath, "/")) {
            classPath = classPath.substring(1);
        }
        return classPath;
    }
}

