/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.IoUtils;
import com.github.kancyframework.springx.utils.PathUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertiesUtils {
    public static Properties loadClasspathProperties(String classpath) throws IOException {
        return PropertiesUtils.loadClasspathProperties(classpath, PropertiesUtils.class.getClassLoader());
    }

    public static Properties loadClasspathProperties(String classpath, ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        properties.load(classLoader.getResourceAsStream(PathUtils.getClassloaderClassPath(classpath)));
        return properties;
    }

    public static Properties loadFileProperties(String filePath) throws IOException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(PathUtils.getFileAbsolutePath(filePath));
            properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
            IoUtils.closeResource(fileInputStream);
            throw throwable;
        }
        IoUtils.closeResource(fileInputStream);
        return properties;
    }
}

