/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.DateUtils;
import com.github.kancyframework.springx.utils.DurationStyle;
import com.github.kancyframework.springx.utils.ObjectUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PropertyHashMap
extends HashMap<String, Object> {
    public <T> Set<T> getSet(String key, Class<T> clazz) {
        return this.getSet(key, clazz, ",");
    }

    public <T> Set<T> getSet(String key, Class<T> clazz, String splitChar) {
        return new HashSet<T>(this.getList(key, clazz, splitChar));
    }

    public <T> List<T> getList(String key, Class<T> clazz) {
        return this.getList(key, clazz, ",");
    }

    public <T> List<T> getList(String key, Class<T> clazz, String splitChar) {
        Object object = this.get(key);
        if (Objects.isNull(object)) {
            return new ArrayList();
        }
        if (object instanceof Collection) {
            ArrayList list = new ArrayList();
            ((Collection)object).forEach((? super T item) -> list.add(ObjectUtils.cast(item, clazz)));
            return list;
        }
        if (object instanceof String) {
            return Arrays.stream(object.toString().split(splitChar)).map(s -> ObjectUtils.cast(s, clazz)).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public Map<String, String> getStringMap(String key) {
        return this.getMap(key, String.class);
    }

    public Map<String, Object> getObjectMap(String key) {
        return this.getMap(key, Object.class);
    }

    public <T> Map<String, T> getMap(String key, Class<T> clazz) {
        Object object = this.get(key);
        if (Objects.isNull(object)) {
            return new HashMap();
        }
        if (object instanceof Map) {
            HashMap map = new HashMap();
            ((Map)object).forEach((k, v) -> map.put(String.valueOf(k), ObjectUtils.cast(v, clazz)));
            return map;
        }
        if (object instanceof String) {
            String[] kvArr = object.toString().split(",");
            HashMap<String, T> map = new HashMap<String, T>();
            for (String kvStr : kvArr) {
                String[] kv = kvStr.split("=");
                map.put(kv[0], ObjectUtils.cast(kv[1], clazz));
            }
            return map;
        }
        return new HashMap();
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String value) {
        Object object = this.get(key);
        if (Objects.isNull(object)) {
            return value;
        }
        return String.valueOf(object);
    }

    public Duration getDuration(String key) {
        return DurationStyle.detectAndParse(this.getString(key, null));
    }

    public Duration getDuration(String key, String value) {
        String durationStr = this.getString(key, value);
        if (Objects.isNull(durationStr)) {
            return null;
        }
        return DurationStyle.detectAndParse(durationStr);
    }

    public Date getDate(String key) {
        return ObjectUtils.cast(this.get(key), Date.class);
    }

    public Date getDate(String key, String defaultValue) {
        Date dateTime = DateUtils.toDateTime(defaultValue);
        if (Objects.isNull(dateTime)) {
            dateTime = DateUtils.toDate(defaultValue);
        }
        return ObjectUtils.cast(this.get(key), Date.class, dateTime);
    }

    public Date getDate(String key, Date defaultValue) {
        return ObjectUtils.cast(this.get(key), Date.class, defaultValue);
    }

    public boolean getBool(String key) {
        return this.getBool(key, false);
    }

    public boolean getBool(String key, boolean defaultValue) {
        return this.getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return ObjectUtils.cast(this.get(key), Boolean.class, defaultValue);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        return ObjectUtils.cast(this.get(key), Long.class, defaultValue);
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double defaultValue) {
        return ObjectUtils.cast(this.get(key), Double.class, defaultValue);
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return ObjectUtils.cast(this.get(key), Integer.class, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> clazz) {
        return ObjectUtils.cast(this.get(key), clazz, null);
    }

    public <T> T getProperty(String key, Class<T> clazz, T defaultValue) {
        return ObjectUtils.cast(this.get(key), clazz, defaultValue);
    }
}

