/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.BeanUtils;
import com.github.kancyframework.springx.utils.ClassUtils;
import com.github.kancyframework.springx.utils.CollectionUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimpleJsonUtils {
    public static Map<String, Object> parseMap(String jsonString) {
        if (StringUtils.isNotBlank(jsonString) && jsonString.trim().startsWith("{") && jsonString.trim().endsWith("}")) {
            if ((jsonString = jsonString.trim()).length() == 2) {
                return new HashMap<String, Object>();
            }
            String kvStr = jsonString.substring(1, jsonString.length() - 1);
            List<String> kvList = StringUtils.toList(kvStr);
            HashMap<String, Object> map = new HashMap<String, Object>();
            kvList.stream().forEach(itemStr -> {
                String[] kv = StringUtils.toArray(itemStr, ":");
                map.put(kv[0].replace("\"", ""), SimpleJsonUtils.castValue(kv[1]));
            });
            return map;
        }
        return new HashMap<String, Object>();
    }

    public static <T> T parseObject(String jsonString, Class<T> beanClass) {
        if (ClassUtils.isAssignableFrom(Map.class, beanClass)) {
            return (T)SimpleJsonUtils.parseMap(jsonString);
        }
        Map<String, Object> map = SimpleJsonUtils.parseMap(jsonString);
        return BeanUtils.mapToBean(map, beanClass);
    }

    public static String toJSONString(Object bean) {
        if (bean instanceof Map) {
            return SimpleJsonUtils.toJSONString((Map)bean);
        }
        return SimpleJsonUtils.toJSONString(BeanUtils.beanToMap(bean));
    }

    private static String toJSONString(Map<?, ?> map) {
        if (CollectionUtils.isEmpty(map)) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (Objects.isNull(value)) continue;
            builder.append("\"").append(entry.getKey()).append("\"").append(":");
            if (ClassUtils.isAssignableFrom(Number.class, value.getClass()) || Objects.equals(Boolean.class, value.getClass()) || Objects.equals(Boolean.TYPE, value.getClass())) {
                builder.append(value);
            } else {
                builder.append("\"").append(value).append("\"");
            }
            builder.append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return String.format("{%s}", builder);
    }

    private static Object castValue(String value) {
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return Boolean.parseBoolean(value);
        }
        try {
            if (value.contains(".")) {
                return Double.parseDouble(value);
            }
            return Long.parseLong(value);
        }
        catch (Exception ex) {
            return value;
        }
    }
}

