/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.ObjectUtils;
import com.github.kancyframework.springx.utils.SimpleJsonUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class StringUtils {
    private static final String COMMA = ",";
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String SPLIT_CHAR = ",";
    private static final String JOIN_CHAR = ",";

    public static String empty() {
        return EMPTY_STRING;
    }

    public static String[] emptyArray() {
        return EMPTY_STRING_ARRAY;
    }

    public static String comma() {
        return ",";
    }

    public static boolean isEmpty(String object) {
        return Objects.isNull(object) || object.isEmpty();
    }

    public static boolean isNotEmpty(String object) {
        return !StringUtils.isEmpty(object);
    }

    public static boolean isBlank(String object) {
        return Objects.isNull(object) || object.trim().isEmpty();
    }

    public static boolean isNotBlank(String object) {
        return !StringUtils.isBlank(object);
    }

    public static boolean isAllBlank(String ... objects) {
        for (String object : objects) {
            if (StringUtils.isBlank(object)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotAllBlank(String ... object) {
        return !StringUtils.isAllBlank(object);
    }

    public static boolean isAnyBlank(String ... objects) {
        for (String object : objects) {
            if (!StringUtils.isBlank(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAnyBlank(String ... object) {
        return !StringUtils.isAnyBlank(object);
    }

    public static String[] addStringToArray(String[] array, String str) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[]{str};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str;
        return newArr;
    }

    public static String[] toArray(String str, String splitChar) {
        if (StringUtils.isNotEmpty(str) && StringUtils.isNotEmpty(splitChar)) {
            return str.split(splitChar);
        }
        return EMPTY_STRING_ARRAY;
    }

    public static String[] toArray(String str) {
        return StringUtils.toArray(str, ",");
    }

    public static List<String> toList(String str, String splitChar) {
        return Arrays.stream(StringUtils.toArray(str, splitChar)).collect(Collectors.toList());
    }

    public static List<String> toList(String str) {
        return StringUtils.toList(str, ",");
    }

    public static Set<String> toSet(String str, String splitChar) {
        return Arrays.stream(StringUtils.toArray(str, splitChar)).collect(Collectors.toSet());
    }

    public static Set<String> toSet(String str) {
        return StringUtils.toSet(str, ",");
    }

    public static String join(String[] stringArray, String joinChar) {
        return String.join((CharSequence)joinChar, stringArray);
    }

    public static String join(String[] stringArray) {
        return StringUtils.join(stringArray, ",");
    }

    public static String lowerFirst(String str) {
        String firstChar = str.substring(0, 1).toLowerCase();
        if (str.length() == 1) {
            return firstChar;
        }
        return String.format("%s%s", firstChar, str.substring(1));
    }

    public static String upperFirst(String str) {
        String firstChar = str.substring(0, 1).toUpperCase();
        if (str.length() == 1) {
            return firstChar;
        }
        return String.format("%s%s", firstChar, str.substring(1));
    }

    public static String underline2camelCase(String underlineStr) {
        if (underlineStr == null || underlineStr.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder(underlineStr.length());
        boolean nextUpperCase = false;
        for (int i = 0; i < underlineStr.length(); ++i) {
            char c = underlineStr.charAt(i);
            if (c == '_') {
                nextUpperCase = true;
                continue;
            }
            if (nextUpperCase) {
                result.append(Character.toUpperCase(c));
                nextUpperCase = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String camelCase2underline(String camelCaseStr) {
        if (camelCaseStr == null || camelCaseStr.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder(camelCaseStr.length());
        for (int i = 0; i < camelCaseStr.length(); ++i) {
            char c = camelCaseStr.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    result.append('_');
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String left(String str, int maxLen) {
        if (Objects.isNull(str)) {
            return null;
        }
        if (str.length() < maxLen) {
            return str;
        }
        return str.substring(0, maxLen);
    }

    public static String toRight(String str, int len) {
        if (str.length() >= len) {
            return str.substring(str.length() - len);
        }
        StringBuffer buffer = new StringBuffer(str);
        for (int i = 0; i < len; ++i) {
            buffer.insert(0, " ");
            if (buffer.length() == len) break;
        }
        return buffer.toString();
    }

    public static String toLeft(String str, int len) {
        if (str.length() >= len) {
            return str.substring(str.length() - len);
        }
        StringBuffer buffer = new StringBuffer(str);
        for (int i = 0; i < len; ++i) {
            buffer.append(" ");
            if (buffer.length() == len) break;
        }
        return buffer.toString();
    }

    public static String getFileExtName(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return null;
        }
        int lastIndexOf = fileName.lastIndexOf(".");
        if (lastIndexOf > 0 && lastIndexOf < fileName.length()) {
            return fileName.substring(lastIndexOf + 1);
        }
        return null;
    }

    public static String getFileSimpleName(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return null;
        }
        String fileExtName = StringUtils.getFileExtName(fileName);
        if (Objects.nonNull(fileExtName)) {
            return new File(fileName).getName().replace("." + fileExtName, EMPTY_STRING);
        }
        return null;
    }

    public static String toJSONString(Object bean) {
        return SimpleJsonUtils.toJSONString(bean);
    }

    public static boolean like(String s, String pattern) {
        String regex = StringUtils.sqlToRegexLike(pattern);
        return Pattern.matches(regex, s);
    }

    static String sqlToRegexLike(String sqlPattern) {
        int len = sqlPattern.length();
        StringBuilder javaPattern = new StringBuilder(len + len);
        for (int i = 0; i < len; ++i) {
            char c = sqlPattern.charAt(i);
            if ("[](){}.*+?$^|#\\".indexOf(c) >= 0) {
                javaPattern.append('\\');
            }
            if (c == '_') {
                javaPattern.append('.');
                continue;
            }
            if (c == '%') {
                javaPattern.append("(?s:.*)");
                continue;
            }
            javaPattern.append(c);
        }
        return javaPattern.toString();
    }

    public static String defaultString(String str, String def) {
        return StringUtils.isEmpty(str) ? def : str;
    }

    public static String defaultIfEmpty(String str, String def) {
        return StringUtils.isEmpty(str) ? def : str;
    }

    public static String defaultIfBlank(String str, String def) {
        return StringUtils.isBlank(str) ? def : str;
    }

    public static boolean equalsAny(String str, String ... anys) {
        for (String any : anys) {
            if (!Objects.equals(str, any)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(String str, String ... anys) {
        if (Objects.isNull(str)) {
            return StringUtils.equalsAny(null, anys);
        }
        for (String any : anys) {
            if (!str.equalsIgnoreCase(any)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithAny(String str, String ... anys) {
        if (Objects.isNull(str)) {
            return false;
        }
        for (String any : anys) {
            if (!str.startsWith(any)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithAnyIgnoreCase(String str, String ... anys) {
        if (Objects.isNull(str)) {
            return false;
        }
        String lowerCase = str.toLowerCase();
        for (String any : anys) {
            if (!lowerCase.startsWith(any.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAny(String str, String ... anys) {
        if (Objects.isNull(str)) {
            return false;
        }
        for (String any : anys) {
            if (!str.endsWith(any)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(String str, String ... anys) {
        if (Objects.isNull(str)) {
            return false;
        }
        String lowerCase = str.toLowerCase();
        for (String any : anys) {
            if (!lowerCase.endsWith(any.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String str, String ... anys) {
        if (Objects.isNull(str)) {
            return false;
        }
        for (String any : anys) {
            if (!str.contains(any)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(String str, String ... anys) {
        if (Objects.isNull(str)) {
            return false;
        }
        for (String any : anys) {
            if (!Objects.nonNull(any) || !str.toLowerCase().contains(any.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

