/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.FileUtils;
import com.github.kancyframework.springx.utils.PathUtils;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class SystemUtils {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String OS = System.getProperty("os.name").toLowerCase();

    public static String getUserName() {
        return System.getenv("USERNAME");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static File getUserFile(String fileName) {
        return SystemUtils.getUserFile(fileName, false);
    }

    public static File getUserFile(String fileName, boolean isNew) {
        String filePath = PathUtils.format(String.format("%s/%s", SystemUtils.getUserHome(), fileName));
        if (isNew) {
            try {
                return FileUtils.createNewFile(filePath);
            }
            catch (IOException e) {
                return new File(filePath);
            }
        }
        return new File(filePath);
    }

    public static String getDesktop() {
        return PathUtils.format(String.format("%s/Desktop", SystemUtils.getUserHome()));
    }

    public static File getDesktopFile(String fileName) {
        return SystemUtils.getDesktopFile(fileName, false);
    }

    public static File getDesktopFile(String fileName, boolean isNew) {
        String filePath = PathUtils.format(String.format("%s/%s", SystemUtils.getDesktop(), fileName));
        if (isNew) {
            try {
                return FileUtils.createNewFile(filePath);
            }
            catch (IOException e) {
                return new File(filePath);
            }
        }
        return new File(filePath);
    }

    public static String getCurrentWorkDir() {
        return System.getProperty("user.dir");
    }

    public static String getTmpdir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getAdminUserName() {
        return "Administrator";
    }

    public static boolean isLinux() {
        return OS.indexOf("linux") >= 0;
    }

    public static boolean isMacOS() {
        return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0;
    }

    public static boolean isWindows() {
        return OS.indexOf("windows") >= 0;
    }

    public static void setClipboardText(String writeMe) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection tText = new StringSelection(writeMe);
        clip.setContents(tText, null);
    }

    public static String getClipboardText() {
        String ret = "";
        Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipTf = sysClip.getContents(null);
        if (clipTf == null) {
            return ret;
        }
        if (clipTf.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                ret = (String)clipTf.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static Image getImageFromClipboard() throws Exception {
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable cc = sysc.getContents(null);
        if (cc == null) {
            return null;
        }
        if (cc.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            return (Image)cc.getTransferData(DataFlavor.imageFlavor);
        }
        return null;
    }

    public static byte[] getImageBytesFromClipboard() throws Exception {
        return SystemUtils.getImageBytes(SystemUtils.getImageFromClipboard());
    }

    public static void setClipboardImage(byte[] imageBytes) {
        SystemUtils.setClipboardImage(new ImageIcon(imageBytes).getImage());
    }

    public static void setClipboardImage(final Image image) {
        Transferable trans = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.imageFlavor.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return image;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    }

    public static void setClipboardContents(final Object ... contents) {
        Transferable trans = new Transferable(){
            private Map<DataFlavor, Object> objectMap = new LinkedHashMap<DataFlavor, Object>();

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                ArrayList<File> files = new ArrayList<File>();
                for (Object content : contents) {
                    DataFlavor dataFlavor = null;
                    if (content instanceof String) {
                        dataFlavor = new DataFlavor(String.class, "Unicode String");
                    } else if (content instanceof Image) {
                        dataFlavor = new DataFlavor("image/x-java-image; class=java.awt.Image", "Image");
                    } else if (content instanceof ImageIcon) {
                        dataFlavor = new DataFlavor("image/x-java-image; class=java.awt.Image", "Image");
                        content = ((ImageIcon)content).getImage();
                    } else if (content instanceof File) {
                        files.add((File)content);
                    }
                    if (!Objects.nonNull(dataFlavor)) continue;
                    this.objectMap.put(dataFlavor, content);
                }
                if (!files.isEmpty()) {
                    DataFlavor dataFlavor = new DataFlavor("application/x-java-file-list;class=java.util.List", null);
                    this.objectMap.put(dataFlavor, files);
                }
                if (!this.objectMap.isEmpty()) {
                    return this.objectMap.keySet().toArray(new DataFlavor[0]);
                }
                return new DataFlavor[0];
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return this.objectMap.containsKey(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                Object object = this.objectMap.get(flavor);
                if (Objects.nonNull(object)) {
                    return object;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    }

    private static byte[] getImageBytes(Image image) {
        if (Objects.isNull(image)) {
            return EMPTY_BYTES;
        }
        if (image instanceof RenderedImage) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)((Object)image), "png", outputStream);
                return outputStream.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return EMPTY_BYTES;
    }

    public static void openBrowser(String sURL) {
        try {
            URI uri = new URI(sURL);
            Desktop desktop = null;
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
            }
            if (desktop != null) {
                desktop.browse(uri);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

