/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Templater {
    private static final Pattern pattern = Pattern.compile("(\\$\\{(.*?)})");

    public static String format(String templateContent, Map<String, Object> templateVariables) {
        return Templater.format(templateContent, templateVariables, null);
    }

    public static String format(String templateContent, Map<String, Object> templateVariables, String defValue) {
        if (Objects.isNull(templateContent) || templateVariables.isEmpty()) {
            return templateContent;
        }
        String template = templateContent;
        Map<String, String> variableMap = Templater.getVariableMap(template);
        Set<Map.Entry<String, String>> entries = variableMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!templateVariables.containsKey(key)) continue;
            Object v = templateVariables.get(key);
            if (Objects.isNull(v)) {
                v = defValue;
            }
            template = template.replace(value, String.valueOf(v));
        }
        return template;
    }

    public static List<String> parseVariableNames(String templateStr) {
        return Templater.getVariableNames(templateStr, true);
    }

    private static Map<String, String> getVariableMap(String templateStr) {
        Matcher matcher = pattern.matcher(templateStr);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        while (matcher.find()) {
            variableMap.put(matcher.group(2).trim(), matcher.group(1));
        }
        return variableMap;
    }

    public static List<String> getVariableNames(String templateStr) {
        return Templater.getVariableNames(templateStr, true);
    }

    public static List<String> getVariableNames(String templateStr, boolean distinct) {
        Matcher matcher = pattern.matcher(templateStr);
        ArrayList<String> names = new ArrayList<String>();
        while (matcher.find()) {
            names.add(matcher.group(2).trim());
        }
        if (distinct) {
            return names.stream().distinct().collect(Collectors.toList());
        }
        return names;
    }
}

