/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.utils;

import com.github.kancyframework.springx.utils.CollectionUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class UrlUtils {
    public static String urlEncode(String str) {
        return UrlUtils.urlEncode(str, Charset.defaultCharset().name());
    }

    public static String urlEncode(String str, String charsetName) {
        try {
            return URLEncoder.encode(str, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlDecode(String str) {
        return UrlUtils.urlDecode(str, Charset.defaultCharset().name());
    }

    public static String urlDecode(String str, String charsetName) {
        try {
            return URLDecoder.decode(str, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> encodeUriVariables(Map<String, ?> uriVariables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(uriVariables.size());
        uriVariables.forEach((key, value) -> {
            String stringValue = value != null ? value.toString() : "";
            result.put((String)key, UrlUtils.urlEncode(stringValue, Charset.defaultCharset().name()));
        });
        return result;
    }

    public static String appendQueryParam(String url, Map<String, Object> uriVariables) {
        if (CollectionUtils.isEmpty(uriVariables)) {
            return url;
        }
        String queryParam = UrlUtils.toQueryParam(uriVariables);
        if (StringUtils.containsAny(url, "?")) {
            if (url.endsWith("?")) {
                return url + queryParam;
            }
            return url + "&" + queryParam;
        }
        return url + "?" + queryParam;
    }

    public static String toQueryParam(Map<String, Object> uriVariables) {
        StringBuilder sb = new StringBuilder();
        uriVariables.forEach((key, value) -> sb.append((String)key).append("=").append(Objects.isNull(value) ? "" : value).append("&"));
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Map<String, String> parseUrlParamMap(String url) {
        int index;
        if (StringUtils.isNotBlank(url) && (index = url.indexOf("?")) < url.length() - 1) {
            String queryString = url.substring(url.indexOf("?")).trim();
            return UrlUtils.parseQueryParamMap(queryString);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> parseQueryParamMap(String queryString) {
        HashMap<String, String> map = new HashMap<String, String>();
        Arrays.stream(queryString.split("&")).forEach(item -> {
            String[] kv = item.split("=", 2);
            if (StringUtils.isNotBlank(kv[0])) {
                map.put(kv[0], kv[1]);
            }
        });
        return map;
    }
}

