/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.script;

import com.github.kancyframework.validationplus.script.ScriptBindHandler;
import com.github.kancyframework.validationplus.utils.FieldUtils;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.script.ScriptEngine;

public abstract class AbstractScriptBindHandler
implements ScriptBindHandler {
    private final Set<String> excludePackages = new HashSet<String>();

    public AbstractScriptBindHandler() {
        this.excludePackages.add(Number.class.getPackage().getName());
        this.excludePackages.add(String.class.getPackage().getName());
        this.excludePackages.add(Collection.class.getPackage().getName());
        this.excludePackages.add(Double.TYPE.getName());
        this.excludePackages.add(Float.TYPE.getName());
        this.excludePackages.add(Long.TYPE.getName());
        this.excludePackages.add(Integer.TYPE.getName());
        this.excludePackages.add(Short.TYPE.getName());
        this.excludePackages.add(Character.TYPE.getName());
        this.excludePackages.add(Byte.TYPE.getName());
    }

    @Override
    public Map<String, Object> getBindings(ScriptEngine engine, String script, Object value) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.putIfAbsent("$", value);
        bindings.putIfAbsent("this", value);
        if (Objects.nonNull(value)) {
            boolean baseClass = false;
            String className = value.getClass().getName();
            for (String excludePackage : this.excludePackages) {
                if (!className.startsWith(excludePackage)) continue;
                baseClass = true;
                break;
            }
            if (baseClass) {
                List<String> variableNames = this.getVariableNames(engine, script, true);
                if (!variableNames.isEmpty()) {
                    variableNames.removeIf(item -> script.contains(item + ".") || Objects.equals(item, "this") || Objects.equals(item, "$"));
                    if (variableNames.size() > 1) {
                        throw new IllegalArgumentException("@ScriptCheck\u6807\u6ce8\u5728\u5b57\u6bb5\u65f6\uff0c\u811a\u672c\u4e0d\u80fd\u5b58\u5728\u591a\u4e2a\u53d8\u91cf\uff0cscript: " + script + ", variables: " + variableNames);
                    }
                    if (variableNames.size() == 1) {
                        bindings.put(variableNames.get(0), value);
                    }
                }
            } else {
                Map<String, Object> beanMap = this.beanToMap(value);
                bindings.putAll(beanMap);
            }
        }
        return bindings;
    }

    protected Map<String, Object> beanToMap(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bean instanceof Map) {
            ((Map)bean).forEach((k, v) -> map.put(String.valueOf(k), v));
            return map;
        }
        Class<?> beanClass = bean.getClass();
        FieldUtils.doWithFields(beanClass, field -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            FieldUtils.makeAccessible(field);
            map.put(field.getName(), field.get(bean));
        });
        return map;
    }

    public List<String> getVariableNames(ScriptEngine engine, String script, boolean cache) {
        return Collections.emptyList();
    }
}

