/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.script;

import com.github.kancyframework.validationplus.script.ScriptBindHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.script.ScriptEngine;
import org.hibernate.validator.spi.scripting.ScriptEngineScriptEvaluator;

public class ValidationPlusScriptEngineScriptEvaluator
extends ScriptEngineScriptEvaluator {
    private static final List<ScriptBindHandler> allScriptBindHandlers = new ArrayList<ScriptBindHandler>();
    private final ScriptEngine engine;
    private final List<ScriptBindHandler> scriptBindHandlers = new ArrayList<ScriptBindHandler>();

    public ValidationPlusScriptEngineScriptEvaluator(ScriptEngine engine) {
        super(engine);
        this.engine = engine;
        List<String> scriptNames = engine.getFactory().getNames();
        allScriptBindHandlers.forEach(scriptBindHandler -> {
            if (scriptNames.contains(scriptBindHandler.lang())) {
                this.scriptBindHandlers.add((ScriptBindHandler)scriptBindHandler);
            }
        });
    }

    public Object evaluate(String script, Map<String, Object> bindings) {
        Object value = bindings.get("$");
        if (Objects.nonNull(value)) {
            this.setCustomBindings(script, bindings, value);
        }
        return super.evaluate(script, bindings);
    }

    private void setCustomBindings(String script, Map<String, Object> bindings, Object value) {
        for (ScriptBindHandler scriptBindHandler : this.scriptBindHandlers) {
            Map<String, Object> subBindings = scriptBindHandler.getBindings(this.engine, script, value);
            bindings.putAll(subBindings);
        }
    }

    static {
        ServiceLoader.load(ScriptBindHandler.class).forEach(allScriptBindHandlers::add);
    }
}

