/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.script.aviator;

import com.github.kancyframework.validationplus.script.AbstractScriptBindHandler;
import com.googlecode.aviator.script.AviatorScriptEngine;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.script.ScriptEngine;

public class AviatorScriptBindHandler
extends AbstractScriptBindHandler {
    private Map<String, List<String>> outVarNameMap = new HashMap<String, List<String>>();

    @Override
    public List<String> getVariableNames(ScriptEngine engine, String script, boolean cache) {
        if (cache) {
            List<String> outVarNames = this.outVarNameMap.get(script);
            if (Objects.isNull(outVarNames)) {
                outVarNames = this.parseVariableNames(engine, script);
                this.outVarNameMap.put(script, outVarNames);
            }
            return outVarNames;
        }
        return this.parseVariableNames(engine, script);
    }

    private List<String> parseVariableNames(ScriptEngine engine, String script) {
        try {
            AviatorScriptEngine aviatorScriptEngine = this.getAviatorScriptEngine(engine);
            List variableNames = aviatorScriptEngine.getEngine().compile(script, true).getVariableNames();
            if (Objects.isNull(variableNames)) {
                return Collections.emptyList();
            }
            return variableNames;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private AviatorScriptEngine getAviatorScriptEngine(ScriptEngine engine) {
        return (AviatorScriptEngine)engine;
    }

    @Override
    public String lang() {
        return "aviator";
    }
}

